/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.util.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;

public class RobustRenameFile
extends File {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final long serialVersionUID = -844192665491079259L;

    public RobustRenameFile(String pathname) {
        super(pathname);
    }

    public RobustRenameFile(URI uri) {
        super(uri);
    }

    public RobustRenameFile(String parent, String child) {
        super(parent, child);
    }

    public RobustRenameFile(File parent, String child) {
        super(parent, child);
    }

    public boolean renameTo(File dest) {
        boolean renamed = super.renameTo(dest);
        if (!renamed) {
            try {
                long srcLastMod = this.lastModified();
                FileUtils.copyFile(this, dest);
                renamed = true;
                try {
                    FileOutputStream fout = new FileOutputStream(this, false);
                    fout.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                File destFile = new File(dest.getAbsolutePath());
                destFile.setLastModified(srcLastMod);
            }
            catch (ExtendedException e) {
                Loggers.logger.log(Level.WARNING, e);
            }
        }
        return renamed;
    }
}

