/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util;

import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import java.io.File;
import java.util.Locale;

public class Resource {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static Resource docResource = null;
    private File resourceDirectory = null;

    Resource(File directory) {
        this.resourceDirectory = directory;
        if (!directory.isDirectory()) {
            directory.mkdirs();
        }
    }

    public String getResource(String resourceName) {
        return this.getResource(resourceName, null);
    }

    public String getResource(String resourceName, Locale locale) {
        String[] candidates;
        if (null == resourceName || resourceName.length() == 0) {
            return null;
        }
        if (null == locale) {
            locale = Locale.getDefault();
        }
        for (String candidate : candidates = this.generateCandidates(resourceName, locale)) {
            File candidateFile;
            if (null == candidate || !(candidateFile = new File(this.resourceDirectory, candidate)).isFile()) continue;
            return candidate;
        }
        return null;
    }

    private String[] generateCandidates(String resourceName, Locale locale) {
        int MaxCandidates = 4;
        String[] candidates = new String[4];
        candidates[3] = resourceName;
        String language = locale.getLanguage();
        if (null != language) {
            candidates[2] = language + "/" + resourceName;
            String country = locale.getCountry();
            if (null != country) {
                candidates[1] = language + "_" + country + "/" + resourceName;
                String variant = locale.getVariant();
                if (null != variant) {
                    candidates[0] = language + "_" + country + "_" + variant + "/" + resourceName;
                }
            }
        }
        return candidates;
    }

    private static synchronized Resource getDocResource() {
        if (null == docResource) {
            File docResourcePath = new File(GlobalConfiguration.getConfiguration().getResourcePath(), "doc");
            docResource = new Resource(docResourcePath);
        }
        return docResource;
    }

    public static String getResource(ResourceType type, String resourceName) {
        return Resource.getResource(type, resourceName, null);
    }

    public static String getResource(ResourceType type, String resourceName, Locale locale) {
        return Resource.getDocResource().getResource(resourceName, locale);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResourceType {
        Doc(0, "doc");

        private final int value;
        private final String resourceName;

        private ResourceType(int value, String resourceName) {
            this.value = value;
            this.resourceName = resourceName;
        }

        public int value() {
            return this.value;
        }

        public String getResourceName() {
            return this.resourceName;
        }
    }
}

