/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;

public class ReliableFileOutputStream
extends OutputStream {
    public static final String reliableFileSuffix = ".ofbk";
    private String originalFilePath = null;
    boolean ioexceptionHappened = false;
    FileOutputStream fos = null;

    public ReliableFileOutputStream(String originalFilePath) throws FileNotFoundException {
        this.fos = new FileOutputStream(originalFilePath + reliableFileSuffix);
        this.originalFilePath = originalFilePath;
    }

    protected void finalize() throws IOException {
        this.close();
    }

    public void close() throws IOException {
        if (this.fos == null) {
            return;
        }
        Message msg = null;
        File originalFile = null;
        File tempFile = null;
        this.fos.close();
        this.fos = null;
        try {
            originalFile = new File(this.originalFilePath);
            tempFile = new File(this.originalFilePath + reliableFileSuffix);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (this.ioexceptionHappened) {
            if (null != tempFile) {
                tempFile.delete();
            }
            return;
        }
        try {
            if (tempFile.exists() && !tempFile.renameTo(originalFile)) {
                if (originalFile.exists() && !originalFile.delete()) {
                    tempFile.delete();
                    msg = new Message("G0119E.FILE_DELETE_ERROR", originalFile.getAbsolutePath());
                    throw new ExtendedException(msg);
                }
                if (!tempFile.renameTo(originalFile)) {
                    msg = new Message("G0166E.RENAME_FAILED", tempFile.getAbsolutePath(), originalFile.getAbsolutePath());
                    throw new ExtendedException(msg);
                }
            }
        }
        catch (ExtendedException ee) {
            msg = new Message("G0169E.RELIABLE_FILE_WRITE_ERROR", originalFile.getAbsolutePath());
            throw this.chainToIOException(new ExtendedException(msg, (Throwable)ee));
        }
    }

    protected void setIOExceptionHappened() {
        this.ioexceptionHappened = true;
    }

    private IOException chainToIOException(Exception e) {
        IOException ie = new IOException();
        ie.initCause(e);
        return ie;
    }

    public void write(byte[] b) throws IOException {
        try {
            this.fos.write(b);
        }
        catch (IOException e) {
            this.ioexceptionHappened = true;
            throw e;
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.fos.write(b, off, len);
        }
        catch (IOException e) {
            this.ioexceptionHappened = true;
            throw e;
        }
    }

    public void write(int b) throws IOException {
        try {
            this.fos.write(b);
        }
        catch (IOException e) {
            this.ioexceptionHappened = true;
            throw e;
        }
    }

    public void flush() throws IOException {
        if (this.fos == null) {
            return;
        }
        try {
            this.fos.flush();
        }
        catch (IOException e) {
            this.ioexceptionHappened = true;
            throw e;
        }
    }

    public FileChannel getChannel() {
        return this.fos.getChannel();
    }

    public final FileDescriptor getFD() throws IOException {
        return this.fos.getFD();
    }
}

