/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;

public class ReliableFileInputStream
extends InputStream {
    private FileInputStream fis = null;

    public ReliableFileInputStream(String name) throws FileNotFoundException {
        try {
            this.fis = new FileInputStream(name);
        }
        catch (FileNotFoundException fe) {
            try {
                this.fis = new FileInputStream(name + ".ofbk");
            }
            catch (Exception e) {
                throw fe;
            }
        }
    }

    public int available() throws IOException {
        return this.fis.available();
    }

    public void close() throws IOException {
        this.fis.close();
    }

    public FileDescriptor getFD() throws IOException {
        return this.fis.getFD();
    }

    public FileChannel getChannel() {
        return this.fis.getChannel();
    }

    public int read() throws IOException {
        return this.fis.read();
    }

    public int read(byte[] b) throws IOException {
        return this.fis.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.fis.read(b, off, len);
    }

    public long skip(long n) throws IOException {
        return this.fis.skip(n);
    }

    public void mark(int readlimit) {
        this.fis.mark(readlimit);
    }

    public boolean markSupported() {
        return this.fis.markSupported();
    }

    public void reset() throws IOException {
        this.fis.reset();
    }
}

