/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class ReliableFile
extends File {
    private static final long serialVersionUID = 7381053632769585469L;
    public static final String reliableFileSuffix = ".ofbk";
    File originalFile = null;

    public ReliableFile(String originalFilePath) throws NullPointerException {
        super(originalFilePath == null ? null : originalFilePath + reliableFileSuffix);
        this.originalFile = new File(originalFilePath);
    }

    public void writeReliable() throws ExtendedException {
        Message msg = null;
        try {
            if (!this.renameTo(this.originalFile)) {
                if (this.originalFile.exists() && !this.originalFile.delete()) {
                    this.delete();
                    msg = new Message("G0119E.FILE_DELETE_ERROR", this.originalFile.getAbsolutePath());
                    throw new ExtendedException(msg);
                }
                if (!this.renameTo(this.originalFile)) {
                    msg = new Message("G0166E.RENAME_FAILED", this.getAbsolutePath(), this.originalFile.getAbsolutePath());
                    throw new ExtendedException(msg);
                }
            }
        }
        catch (ExtendedException ee) {
            msg = new Message("G0169E.RELIABLE_FILE_WRITE_ERROR", this.originalFile.getAbsolutePath());
            throw new ExtendedException(msg, (Throwable)ee);
        }
    }

    public static FileInputStream getReliableFileInputStream(String originalFilePath) throws IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(originalFilePath);
        }
        catch (IOException e) {
            try {
                is = new FileInputStream(originalFilePath + reliableFileSuffix);
            }
            catch (IOException e1) {
                if (e.getCause() == e) {
                    e.initCause(e1);
                }
                throw e;
            }
        }
        return is;
    }
}

