/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util;

public abstract class PriorityQueue {
    private Object[] heap;
    private int size;
    private int maxSize;

    protected abstract boolean lessThan(Object var1, Object var2);

    protected abstract void makeMinPriority(Object var1, Object var2);

    protected final void initialize(int initMaxSize) {
        this.size = 0;
        int heapSize = initMaxSize + 1;
        this.heap = new Object[heapSize];
        this.maxSize = initMaxSize;
    }

    public final void put(Object element) {
        ++this.size;
        this.heap[this.size] = element;
        this.upHeap(this.size);
    }

    public boolean insert(Object element) {
        if (this.size < this.maxSize) {
            this.put(element);
            return true;
        }
        if (this.size > 0 && !this.lessThan(element, this.top())) {
            this.heap[1] = element;
            this.adjustTop();
            return true;
        }
        return false;
    }

    public final Object top() {
        if (this.size > 0) {
            return this.heap[1];
        }
        return null;
    }

    public final Object pop() {
        if (this.size > 0) {
            Object result = this.heap[1];
            this.heap[1] = this.heap[this.size];
            this.heap[this.size] = null;
            --this.size;
            this.downHeap(1);
            return result;
        }
        return null;
    }

    public final void adjustTop() {
        this.downHeap(1);
    }

    public final QueueHandle find(Object a) {
        int i = -1;
        QueueHandle qh = null;
        for (i = 1; i <= this.size; ++i) {
            Object obj = this.heap[i];
            if (!a.equals(obj)) continue;
            qh = new QueueHandle(obj, i);
            break;
        }
        return qh;
    }

    public final boolean remove(QueueHandle qh) {
        boolean removed = false;
        if (qh != null && qh.getIndex() > 0) {
            int index = qh.getIndex();
            this.makeMinPriority(this.heap[index], this.heap[1]);
            this.upHeap(index);
            this.pop();
            removed = true;
        }
        return removed;
    }

    public final int size() {
        return this.size;
    }

    public final void clear() {
        for (int i = 0; i <= this.size; ++i) {
            this.heap[i] = null;
        }
        this.size = 0;
    }

    private final void upHeap(int idx) {
        int i = idx;
        Object node = this.heap[i];
        for (int j = i >>> 1; j > 0 && this.lessThan(node, this.heap[j]); j >>>= 1) {
            this.heap[i] = this.heap[j];
            i = j;
        }
        this.heap[i] = node;
    }

    private final void downHeap(int idx) {
        int i = idx;
        Object node = this.heap[i];
        int j = i << 1;
        int k = j + 1;
        if (k <= this.size && this.lessThan(this.heap[k], this.heap[j])) {
            j = k;
        }
        while (j <= this.size && this.lessThan(this.heap[j], node)) {
            this.heap[i] = this.heap[j];
            i = j;
            k = (j = i << 1) + 1;
            if (k > this.size || !this.lessThan(this.heap[k], this.heap[j])) continue;
            j = k;
        }
        this.heap[i] = node;
    }

    public static class QueueHandle {
        private Object obj;
        private int index;

        public QueueHandle(Object obj, int index) {
            this.obj = obj;
            this.index = index;
        }

        public Object getObject() {
            return this.obj;
        }

        int getIndex() {
            return this.index;
        }
    }
}

