/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.StandardMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanHelper {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final String DocumentIngestDomain = "com.ibm.es.whitney.documentIngest";
    public static final String SearchRuntimeDomain = "com.ibm.es.whitney.runtime";
    private static MBeanHelper singleInstance = null;

    public static MBeanHelper getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new MBeanHelper();
        }
        return singleInstance;
    }

    private MBeanHelper() {
    }

    public void registerMonitoredObject(String domain, String objectName, Object instance, Class<?> mBeanInterface) throws MalformedObjectNameException {
        ObjectName monitoredObjectName = new ObjectName(domain, "name", objectName);
        this.registerMonitoredObject(monitoredObjectName, instance, mBeanInterface);
    }

    public void registerMonitoredObject(ObjectName objectName, Object instance, Class<?> mBeanInterface) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            StandardMBean mbean = new StandardMBean(instance, mBeanInterface);
            mbs.registerMBean(mbean, objectName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unregisterMonitoredObject(String domain, String objectName) throws MalformedObjectNameException {
        ObjectName monitoredObjectName = new ObjectName(domain, "name", objectName);
        this.unregisterMonitoredObject(monitoredObjectName);
    }

    public void unregisterMonitoredObject(ObjectName objectName) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.unregisterMBean(objectName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object getMonitoredObject(String domain, String objectName, Class<?> mBeanInterface) throws MalformedObjectNameException {
        ObjectName monitoredObjectName = new ObjectName(domain, "name", objectName);
        return this.getMonitoredObject(monitoredObjectName, mBeanInterface);
    }

    public Object getMonitoredObject(ObjectName objectName, Class<?> mBeanInterface) {
        Object mBean = null;
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mBean = MBeanServerInvocationHandler.newProxyInstance(mbs, objectName, mBeanInterface, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mBean;
    }
}

