/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util;

import com.ibm.icu.text.SimpleDateFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.CharacterIterator;
import java.text.ParseException;
import java.text.StringCharacterIterator;
import java.util.Date;
import java.util.GregorianCalendar;

public class Iso8601Date {
    static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private Integer year;
    private Integer month;
    private Integer day;
    private Integer hour;
    private Integer minute;
    private Integer second;

    public static String format(Date date) {
        return dateFormat.format(date);
    }

    public boolean needsRounding() {
        return this.second == null;
    }

    public Date date() {
        if (this.second != null) {
            return new GregorianCalendar(this.year, this.month, this.day, this.hour, this.minute, this.second).getTime();
        }
        if (this.minute != null) {
            return new GregorianCalendar(this.year, this.month, this.day, this.hour, this.minute).getTime();
        }
        if (this.day != null) {
            return new GregorianCalendar(this.year, this.month, this.day).getTime();
        }
        if (this.month != null) {
            return new GregorianCalendar(this.year, this.month, 1).getTime();
        }
        return new GregorianCalendar(this.year, 0, 1).getTime();
    }

    public Date roundUp() {
        if (this.second != null) {
            return new GregorianCalendar(this.year, this.month, this.day, this.hour, this.minute, this.second).getTime();
        }
        if (this.minute != null) {
            return new GregorianCalendar(this.year, this.month, this.day, this.hour, this.minute, 59).getTime();
        }
        if (this.day != null) {
            return new GregorianCalendar(this.year, this.month, this.day, 23, 59, 59).getTime();
        }
        if (this.month != null) {
            GregorianCalendar cal = new GregorianCalendar(this.year, this.month, 1);
            cal.add(2, 1);
            cal.add(13, -1);
            return cal.getTime();
        }
        return new GregorianCalendar(this.year, 11, 31, 23, 59, 59).getTime();
    }

    private Iso8601Date(Integer year, Integer month, Integer day, Integer hour, Integer minute, Integer second) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        if (this.hour != null && this.hour == 24) {
            if (this.day < 28) {
                this.hour = 0;
                Iso8601Date iso8601Date = this;
                iso8601Date.day = iso8601Date.day + 1;
            } else {
                GregorianCalendar cal = new GregorianCalendar(this.year, this.month, this.day);
                cal.add(5, 1);
                this.year = cal.get(1);
                this.month = cal.get(2);
                this.day = cal.get(5);
                this.hour = 0;
            }
        }
    }

    public static Iso8601Date parse(String input) throws ParseException {
        StringCharacterIterator iter = new StringCharacterIterator(input.trim());
        Integer year = Iso8601Date.expectNumber(iter, 4);
        boolean hasDash = Iso8601Date.optionalChar(iter, '-');
        Integer month = hasDash ? Integer.valueOf(Iso8601Date.expectNumber(iter, 2)) : Iso8601Date.optionalNumber(iter, 2);
        if (month != null) {
            if (month < 1 || month > 12) {
                throw new ParseException("Month must be between 1 and 12", iter.getIndex() - 2);
            }
            month = month - 1;
        }
        Integer day = null;
        if (month != null) {
            if (hasDash) {
                if (Iso8601Date.optionalChar(iter, '-')) {
                    day = Iso8601Date.expectNumber(iter, 2);
                }
            } else {
                day = Iso8601Date.optionalNumber(iter, 2);
            }
        }
        if (day != null) {
            int maxDay = new GregorianCalendar(year, month, 1).getActualMaximum(5);
            if (day < 1 || day > maxDay) {
                throw new ParseException("Month must be between 1 and " + maxDay, iter.getIndex() - 2);
            }
        }
        Integer hour = null;
        Integer minute = null;
        Integer second = null;
        if (day != null && Iso8601Date.checkTime(iter)) {
            hour = Iso8601Date.expectNumber(iter, 2);
            if (hour > 24) {
                throw new ParseException("Hour must be between 0 and 24", iter.getIndex() - 2);
            }
            boolean hasColon = Iso8601Date.optionalChar(iter, ':');
            minute = Iso8601Date.expectNumber(iter, 2);
            if (hour == 24) {
                if (minute != 0) {
                    throw new ParseException("Minute must be 0", iter.getIndex() - 2);
                }
            } else if (minute > 59) {
                throw new ParseException("Minute must be between 0 and 59", iter.getIndex() - 2);
            }
            if (hasColon) {
                if (Iso8601Date.optionalChar(iter, ':')) {
                    second = Iso8601Date.expectNumber(iter, 2);
                }
            } else {
                second = Iso8601Date.optionalNumber(iter, 2);
            }
            if (second != null) {
                if (hour == 24) {
                    if (second != 0) {
                        throw new ParseException("Second must be 0", iter.getIndex() - 2);
                    }
                } else if (second > 59) {
                    throw new ParseException("Second must be between 0 and 59", iter.getIndex() - 2);
                }
                if (Iso8601Date.optionalChar(iter, '.')) {
                    while (Iso8601Date.optionalNumber(iter, 1) != null) {
                    }
                }
            }
        }
        if (iter.current() != '\uffff') {
            throw new ParseException("Expected end of input", iter.getIndex());
        }
        return new Iso8601Date(year, month, day, hour, minute, second);
    }

    private static int expectNumber(CharacterIterator iter, int expectedDigits) throws ParseException {
        int number = 0;
        while (expectedDigits > 0) {
            char ch = iter.current();
            if (ch >= '0' && ch <= '9') {
                number = number * 10 + Character.digit(ch, 10);
                iter.next();
                --expectedDigits;
                continue;
            }
            throw new ParseException("Digit expected", iter.getIndex());
        }
        return number;
    }

    private static Integer optionalNumber(CharacterIterator iter, int numDigits) throws ParseException {
        char ch = iter.current();
        if (ch >= '0' && ch <= '9') {
            return Iso8601Date.expectNumber(iter, numDigits);
        }
        return null;
    }

    private static boolean optionalChar(CharacterIterator iter, char ch) {
        if (iter.current() == ch) {
            iter.next();
            return true;
        }
        return false;
    }

    private static boolean checkTime(CharacterIterator iter) throws ParseException {
        char ch = iter.current();
        if (ch == ' ' || ch == 'T') {
            iter.next();
            return true;
        }
        if (ch == '\uffff') {
            return false;
        }
        throw new ParseException("Expected 'T' or blank", iter.getIndex());
    }

    public static void main(String[] args) throws IOException {
        String dateString;
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        while ((dateString = reader.readLine()) != null && dateString.length() != 0) {
            try {
                Iso8601Date isoDate = Iso8601Date.parse(dateString);
                System.out.println("date = " + Iso8601Date.format(isoDate.date()) + ", roundUp = " + Iso8601Date.format(isoDate.roundUp()));
            }
            catch (ParseException e) {
                System.out.println("Caught " + e + " position = " + e.getErrorOffset() + " here: " + dateString.substring(e.getErrorOffset()));
            }
        }
    }
}

