/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public final class HostNameUtils {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static String LocalHostFQDN = null;

    public static String getLocalHostFQDN() throws SocketException {
        if (null == LocalHostFQDN) {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                InetAddress address;
                NetworkInterface netInterface = interfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = netInterface.getInetAddresses();
                if (!inetAddresses.hasMoreElements() || (address = inetAddresses.nextElement()).isLoopbackAddress()) continue;
                LocalHostFQDN = address.getCanonicalHostName();
            }
        }
        return LocalHostFQDN;
    }

    public static boolean doesHostHaveMultipleIPs() throws SocketException {
        int size = 0;
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            InetAddress address;
            NetworkInterface netInterface = interfaces.nextElement();
            Enumeration<InetAddress> inetAddresses = netInterface.getInetAddresses();
            if (!inetAddresses.hasMoreElements() || (address = inetAddresses.nextElement()).isLoopbackAddress()) continue;
            ++size;
        }
        return size > 1;
    }
}

