/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.util.Base64;
import java.security.MessageDigest;

public class HashUtils {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public static byte[] md5(String source) throws ExtendedException {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(source.getBytes());
        }
        catch (Exception e) {
            Message msg = new Message("todo");
            throw new ExtendedException(msg, (Throwable)e);
        }
    }

    public static byte[] sha(String source) throws ExtendedException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            return md.digest(source.getBytes());
        }
        catch (Exception e) {
            Message msg = new Message("todo");
            throw new ExtendedException(msg, (Throwable)e);
        }
    }

    public static byte[] sha256(String source) throws ExtendedException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            return md.digest(source.getBytes());
        }
        catch (Exception e) {
            Message msg = new Message("todo");
            throw new ExtendedException(msg, (Throwable)e);
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: <word>");
            System.exit(0);
        }
        try {
            String word = args[0];
            System.out.println("Word: " + word);
            byte[] data = HashUtils.md5(word);
            String base64 = Base64.encode(data);
            System.out.print(" MD5 (Raw): ");
            for (byte b : data) {
                System.out.print(b);
            }
            System.out.println();
            System.out.println(" MD5 (Base 64): " + base64);
            data = HashUtils.sha(word);
            base64 = Base64.encode(data);
            System.out.print(" SHA (Raw): ");
            for (byte b : data) {
                System.out.print(b);
            }
            System.out.println();
            System.out.println(" SHA (Base 64): " + base64);
            data = HashUtils.sha256(word);
            base64 = Base64.encode(data);
            System.out.print(" SHA 256 (Raw): ");
            for (byte b : data) {
                System.out.print(b);
            }
            System.out.println();
            System.out.println(" SHA 256 (Base 64): " + base64);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

