/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String invalidCharsForWindows = "\"*/:<>?\\|";
    private static final String[] invalidNamesForWindows = new String[]{"COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT1", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9", "AUX", "CON", "NUL", "PRN", "CLOCK$"};
    private static final String invalidCharsForLinux = "/";

    public static Vector<String> validateDirectoryContains(String pathName, String[] itemNames) {
        File directory = new File(pathName);
        Vector<String> missingItems = new Vector<String>();
        String[] directoryList = directory.list();
        if (directoryList != null && directoryList.length > 0) {
            for (int i = 0; i < itemNames.length; ++i) {
                boolean found = false;
                for (int j = 0; j < directoryList.length && !found; ++j) {
                    if (!directoryList[j].equalsIgnoreCase(itemNames[i])) continue;
                    found = true;
                }
                if (found) continue;
                missingItems.add(itemNames[i]);
            }
        } else {
            for (int i = 0; i < itemNames.length; ++i) {
                missingItems.add(itemNames[i]);
            }
        }
        return missingItems;
    }

    public static Vector<String> removeDirectory(File file) {
        return FileUtils.cleanDirectory(file, true);
    }

    public static Vector<String> cleanDirectory(File file) {
        return FileUtils.cleanDirectory(file, false);
    }

    public static void copyDirectory(File srcDir, File tgtDir, boolean newFilesOnly) throws ExtendedException {
        if (srcDir.exists() && srcDir.isDirectory()) {
            boolean dirCreated;
            if (!(tgtDir.exists() && tgtDir.isDirectory() || (dirCreated = tgtDir.mkdirs()))) {
                Message msg = new Message("G0105E.DIRECTORY_CREATE_FAILED", tgtDir.getAbsolutePath());
                ExtendedException ee = new ExtendedException(msg);
                throw ee;
            }
            File[] srcFileList = srcDir.listFiles();
            if (srcFileList != null && srcFileList.length > 0) {
                for (int i = 0; i < srcFileList.length; ++i) {
                    File newTgtFile = new File(tgtDir, srcFileList[i].getName());
                    if (srcFileList[i].isDirectory()) {
                        FileUtils.copyDirectory(srcFileList[i], newTgtFile, newFilesOnly);
                        continue;
                    }
                    if (newFilesOnly && newTgtFile.exists()) continue;
                    FileUtils.copyFile(srcFileList[i], newTgtFile);
                }
            }
        }
    }

    public static void copyFile(String srcFileName, String tgtFileName) throws ExtendedException {
        FileUtils.copyFile(new File(srcFileName), new File(tgtFileName));
    }

    public static void copyFile(File srcFile, File tgtFile) throws ExtendedException {
        FileInputStream srcData = null;
        FileOutputStream tgtData = null;
        try {
            srcData = new FileInputStream(srcFile);
            if (tgtFile.exists()) {
                tgtFile.delete();
            }
            tgtData = new FileOutputStream(tgtFile);
            byte[] data = new byte[1024];
            int bytesRead = 0;
            bytesRead = srcData.read(data);
            while (bytesRead > 0) {
                tgtData.write(data, 0, bytesRead);
                bytesRead = srcData.read(data);
            }
            tgtData.flush();
            tgtData.close();
            srcData.close();
        }
        catch (Exception e) {
            Message msg = new Message("G0033E.FILE_COPY_ERROR", srcFile.getAbsolutePath(), tgtFile.getAbsolutePath());
            ExtendedException ee = new ExtendedException(msg, (Throwable)e);
            throw ee;
        }
        finally {
            if (srcData != null) {
                try {
                    srcData.close();
                }
                catch (IOException e) {}
            }
            if (tgtData != null) {
                try {
                    tgtData.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static void copyFile(File srcFile, File tgtFile, CopyReplaceLine[] findReplaceLines) throws ExtendedException {
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            if (tgtFile.exists()) {
                tgtFile.delete();
            }
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(srcFile), "UTF-8"));
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tgtFile), "UTF-8"));
            int curCopyReplaceIndex = 0;
            CopyReplaceLine curCopyReplace = null;
            if (null != findReplaceLines && findReplaceLines.length > 0) {
                curCopyReplace = findReplaceLines[curCopyReplaceIndex];
            }
            int startLineIndex = -1;
            String line = reader.readLine();
            while (null != line) {
                String lineToWrite = line;
                if (null != curCopyReplace) {
                    if (-1 == startLineIndex) {
                        startLineIndex = line.indexOf(curCopyReplace.startLine);
                    } else if (-1 != line.indexOf(curCopyReplace.findLine)) {
                        lineToWrite = curCopyReplace.replaceLine;
                    } else if (-1 != line.indexOf(curCopyReplace.endLine)) {
                        startLineIndex = -1;
                        curCopyReplace = ++curCopyReplaceIndex >= findReplaceLines.length ? null : findReplaceLines[curCopyReplaceIndex];
                    }
                }
                writer.write(lineToWrite);
                writer.newLine();
                line = reader.readLine();
            }
            reader.close();
            writer.close();
            reader = null;
            writer = null;
        }
        catch (Exception e) {
            Message msg = new Message("G0033E.FILE_COPY_ERROR", srcFile.getAbsolutePath(), tgtFile.getAbsolutePath());
            ExtendedException ee = new ExtendedException(msg, (Throwable)e);
            throw ee;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(String fileName) throws IOException {
        byte[] fileData = null;
        FileInputStream srcData = null;
        try {
            srcData = new FileInputStream(fileName);
            fileData = FileUtils.readStream(srcData);
        }
        finally {
            if (srcData != null) {
                try {
                    srcData.close();
                }
                catch (IOException iOException) {}
            }
        }
        return fileData;
    }

    public static byte[] readStream(InputStream is) throws IOException {
        ByteArrayOutputStream fileData = new ByteArrayOutputStream(4096);
        byte[] dataBuffer = new byte[4096];
        int bytesRead = 0;
        bytesRead = is.read(dataBuffer);
        while (bytesRead > 0) {
            fileData.write(dataBuffer, 0, bytesRead);
            bytesRead = is.read(dataBuffer);
        }
        return fileData.toByteArray();
    }

    public static Message isValidDirectoryName(String name, boolean attemptDirectoryCreate) {
        String tempDir;
        File directory;
        String lastChar;
        int i;
        Message errorMsg = null;
        String invalidChars = null;
        String[] invalidNames = null;
        boolean allowTrailingBlank = false;
        GlobalConfiguration globalConfig = GlobalConfiguration.getConfiguration();
        if (globalConfig.isWindows()) {
            invalidChars = invalidCharsForWindows;
            invalidNames = invalidNamesForWindows;
            allowTrailingBlank = false;
        } else if (globalConfig.isLinux() || globalConfig.isAIX()) {
            invalidChars = invalidCharsForLinux;
            invalidNames = null;
            allowTrailingBlank = true;
        }
        if (errorMsg == null && (name == null || name.trim().length() == 0)) {
            errorMsg = new Message("G0104E.BAD_DIRECTORY_NAME", "");
        }
        if (errorMsg == null && name.contains(File.separator)) {
            errorMsg = new Message("G0103E.BAD_CHAR_IN_DIRECTORY_NAME", name, File.separator);
        }
        if (errorMsg == null && invalidChars != null) {
            for (i = 0; i < invalidChars.length() && errorMsg == null; ++i) {
                String badChar = invalidChars.substring(i, i + 1);
                if (!name.contains(badChar)) continue;
                errorMsg = new Message("G0103E.BAD_CHAR_IN_DIRECTORY_NAME", name, badChar);
            }
        }
        if (errorMsg == null && !allowTrailingBlank && (lastChar = name.substring(name.length() - 1)).trim().length() == 0) {
            errorMsg = new Message("G0103E.BAD_CHAR_IN_DIRECTORY_NAME", name, "\"" + lastChar + "\"");
        }
        if (errorMsg == null && invalidNames != null) {
            for (i = 0; i < invalidNames.length; ++i) {
                if (!invalidNames[i].equals(name)) continue;
                errorMsg = new Message("G0104E.BAD_DIRECTORY_NAME", name);
            }
        }
        if (errorMsg == null && attemptDirectoryCreate && !(directory = new File(tempDir = globalConfig.getTempDirectory(), name)).exists()) {
            boolean createOk = directory.mkdir();
            if (createOk) {
                directory.delete();
            } else {
                errorMsg = new Message("G0105E.DIRECTORY_CREATE_FAILED", directory.getAbsolutePath());
            }
        }
        return errorMsg;
    }

    public static void deleteFile(String directory, String fileName) throws ExtendedException {
        if (!directory.endsWith(File.separator)) {
            directory = directory + File.separator;
        }
        String fullName = directory + fileName;
        FileUtils.deleteFile(fullName);
    }

    public static void deleteFile(String fileName) throws ExtendedException {
        boolean deleted;
        File f = new File(fileName);
        if (f.exists() && !(deleted = FileUtils.deleteFileWithRetry(f))) {
            Message msg = new Message("G0119E.FILE_DELETE_ERROR", fileName);
            ExtendedException ee = new ExtendedException(msg);
            throw ee;
        }
    }

    public static boolean doesFileListOnlyContainDirectories(Vector<String> fileNames) {
        boolean onlyDirectories = true;
        if (fileNames.size() > 0) {
            for (int i = 0; i < fileNames.size() && onlyDirectories; ++i) {
                File f = new File(fileNames.get(i));
                if (!f.exists() || f.isDirectory()) continue;
                onlyDirectories = false;
            }
        }
        return onlyDirectories;
    }

    private static Vector<String> cleanDirectory(File file, boolean removeWhenDone) {
        boolean deleted;
        File[] fileList;
        Vector<String> errorFiles = new Vector<String>();
        if (file == null || !file.exists()) {
            return errorFiles;
        }
        if (file.isDirectory() && (fileList = file.listFiles()) != null && fileList.length > 0) {
            for (int i = 0; i < fileList.length; ++i) {
                Vector<String> errors = FileUtils.cleanDirectory(fileList[i], true);
                errorFiles.addAll(errors);
            }
        }
        if (removeWhenDone && errorFiles.size() == 0 && !(deleted = FileUtils.deleteFileWithRetry(file))) {
            errorFiles.add(file.getAbsoluteFile().toString());
        }
        return errorFiles;
    }

    private static boolean deleteFileWithRetry(File f) {
        boolean deleted = false;
        for (int i = 0; i < 10 && !deleted; ++i) {
            deleted = f.delete();
            if (deleted) continue;
            try {
                Thread.sleep(150L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return deleted;
    }

    public static final class CopyReplaceLine {
        private String startLine = null;
        private String endLine = null;
        private String findLine = null;
        private String replaceLine = null;

        public CopyReplaceLine(String startLine, String endLine, String findLine, String replaceLine) {
            this.startLine = startLine;
            this.endLine = endLine;
            this.findLine = findLine;
            this.replaceLine = replaceLine;
        }
    }
}

