/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util;

import java.io.File;
import java.util.Vector;

public class FileDeleteTask
implements Runnable {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final long FileDeleteTaskSleepTime = 300000L;
    private Vector<File> filesToBeDeleted = new Vector();
    private Thread thread = null;
    private long fileDeleteInterval = 300000L;
    private volatile boolean stop = false;

    public void start() {
        if (this.thread == null) {
            this.thread = new Thread((Runnable)this, "FileDeleteTask");
            this.stop = false;
            this.thread.setDaemon(true);
            this.thread.setPriority(1);
            this.thread.start();
        }
    }

    public void stop() throws InterruptedException {
        if (this.thread != null) {
            this.stop = true;
            this.thread.interrupt();
            this.thread.join();
        }
    }

    public void addFileToBeDeleted(File f) {
        this.filesToBeDeleted.add(f);
    }

    public void setFileDeleteInterval(long fileDeleteInterval) {
        this.fileDeleteInterval = fileDeleteInterval;
    }

    public void run() {
        while (!this.stop) {
            for (int i = this.filesToBeDeleted.size() - 1; i >= 0; --i) {
                File f = this.filesToBeDeleted.get(i);
                if (f.exists()) {
                    boolean deleteSuccessful = f.delete();
                    if (!deleteSuccessful) continue;
                    this.filesToBeDeleted.remove(i);
                    continue;
                }
                this.filesToBeDeleted.remove(i);
            }
            try {
                Thread.sleep(this.fileDeleteInterval);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

