/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.util.Encryption;
import java.net.URLEncoder;
import java.security.Key;

public class FetchedUrlCredentialsHandler {
    private Key key = null;
    private static FetchedUrlCredentialsHandler fetchedUrlCredentialsHandler = null;

    public static FetchedUrlCredentialsHandler getInstance() {
        if (fetchedUrlCredentialsHandler == null) {
            fetchedUrlCredentialsHandler = new FetchedUrlCredentialsHandler();
        }
        return fetchedUrlCredentialsHandler;
    }

    private FetchedUrlCredentialsHandler() {
    }

    public String encrypt(String password) {
        if (password == null) {
            return null;
        }
        if (this.key == null) {
            try {
                this.key = Encryption.generateKey(null);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.key != null) {
            try {
                return Encryption.encrypt(password, this.key);
            }
            catch (ExtendedException e) {
                return null;
            }
        }
        return null;
    }

    public String decrypt(String encPassword) {
        if (encPassword == null) {
            return null;
        }
        if (this.key != null) {
            try {
                return Encryption.decrypt(encPassword, this.key);
            }
            catch (ExtendedException e) {
                return null;
            }
        }
        return null;
    }

    public String buildCredentialsParameterBlock(String userName, String encPassword) {
        if (userName == null || encPassword == null) {
            return null;
        }
        String urlEncPassword = null;
        String urlEncUser = null;
        try {
            urlEncPassword = URLEncoder.encode(encPassword, "UTF-8");
            urlEncUser = URLEncoder.encode(userName, "UTF-8");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (urlEncPassword != null && urlEncUser != null) {
            return "&encpassword=" + urlEncPassword + "&username=" + urlEncUser;
        }
        return "&encpassword=" + encPassword + "&username=" + userName;
    }
}

