/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpiryMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private HashMap<String, Long> entries = new HashMap();
    private long timeOutDuration = 0L;

    public Set<String> keySet() {
        return this.entries.keySet();
    }

    public int size() {
        return this.entries.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean checkAndRemoveExpired(String key, long currentTimestamp) {
        if (this.entries.containsKey(key)) {
            Long val = this.getValue(key);
            if (currentTimestamp < val - this.timeOutDuration) {
                this.entries.remove(key);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean containsKey(String key) {
        return this.entries.containsKey(key);
    }

    public Long getValue(String key) {
        Long value = this.entries.get(key);
        if (value == null) {
            return 0L;
        }
        return value;
    }

    public void put(String key, Long value) {
        this.entries.put(key, value);
    }

    public void removeExpired(long currentTimestamp) {
        for (Map.Entry<String, Long> entry : this.entries.entrySet()) {
            String key = entry.getKey();
            Long value = entry.getValue();
            if (currentTimestamp >= value - this.timeOutDuration) continue;
            this.entries.remove(key);
        }
    }

    public ExpiryMap(long cuttOff) {
        this.timeOutDuration = cuttOff;
    }
}

