/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.InvalidArgumentException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.jvm.JvmSupportManager;
import com.ibm.es.nuvo.util.Base64;
import com.ibm.es.nuvo.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class Encryption {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String CipherAlgorithm = "AES";
    private static Key defaultKey = null;
    private static final byte[] JUnitByteKey = new byte[]{3, -61, -121, 22, -80, -91, 45, 49, -42, 52, -82, 60, 113, 57, -116, 77};

    public static String encrypt(String text) throws ExtendedException {
        if (defaultKey == null) {
            throw new RuntimeException("Programming error: the default key was not set for encryption/decryption routines");
        }
        return Encryption.encrypt(text, defaultKey);
    }

    public static String encrypt(String text, Key key) throws ExtendedException {
        byte[] encryptedBytes = Encryption.encryptToBytes(text, key);
        String encoded = Base64.encode(encryptedBytes);
        return encoded;
    }

    public static byte[] encryptToBytes(String text) throws ExtendedException {
        return Encryption.encryptToBytes(text, defaultKey);
    }

    public static byte[] encryptToBytes(String text, Key key) throws ExtendedException {
        byte[] encryptedBytes = null;
        try {
            byte[] strBytes = text.getBytes("UTF-8");
            encryptedBytes = Encryption.encrypt(strBytes, key);
        }
        catch (UnsupportedEncodingException e) {
            Message msg = new Message("G0098E.ERROR_ENCRYPTING_DATA");
            ExtendedException ee = new ExtendedException(msg, (Throwable)e);
            throw ee;
        }
        return encryptedBytes;
    }

    public static byte[] encrypt(byte[] bytes) throws ExtendedException {
        return Encryption.encrypt(bytes, defaultKey);
    }

    public static byte[] encrypt(byte[] bytes, Key key) throws ExtendedException {
        if (key == null) {
            throw new RuntimeException("Error trying to encrypt data with no key set.  You need to set the default key, or pass a key.");
        }
        byte[] encryptedBytes = null;
        try {
            Cipher cipher = JvmSupportManager.getJvmSupportInterface().getCipherFor(CipherAlgorithm);
            cipher.init(1, key);
            encryptedBytes = cipher.doFinal(bytes);
        }
        catch (Exception e) {
            Message msg = new Message("G0098E.ERROR_ENCRYPTING_DATA");
            ExtendedException ee = new ExtendedException(msg, (Throwable)e);
            throw ee;
        }
        return encryptedBytes;
    }

    public static String decrypt(String base64String) throws ExtendedException {
        return Encryption.decrypt(base64String, defaultKey);
    }

    public static String decrypt(String base64String, Key key) throws ExtendedException {
        String text = null;
        char[] chars = new char[base64String.length()];
        base64String.getChars(0, base64String.length(), chars, 0);
        byte[] decodedBytes = Base64.decode(chars, chars.length);
        text = Encryption.decryptFromBytes(decodedBytes, key);
        return text;
    }

    public static String decryptFromBytes(byte[] encryptedBytes) throws ExtendedException {
        return Encryption.decryptFromBytes(encryptedBytes, defaultKey);
    }

    public static String decryptFromBytes(byte[] encryptedBytes, Key key) throws ExtendedException {
        byte[] decryptedBytes = Encryption.decrypt(encryptedBytes, key);
        String text = null;
        try {
            text = new String(decryptedBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Message msg = new Message("G0099E.ERROR_DECRYPTING_DATA");
            ExtendedException ee = new ExtendedException(msg, (Throwable)e);
            throw ee;
        }
        return text;
    }

    public static byte[] decrypt(byte[] encryptedBytes) throws ExtendedException {
        return Encryption.decrypt(encryptedBytes, defaultKey);
    }

    public static byte[] decrypt(byte[] encryptedBytes, Key key) throws ExtendedException {
        if (key == null) {
            throw new RuntimeException("Error trying to decrypt data with no key set.  You need to set the default key, or pass a key.");
        }
        byte[] decryptedBytes = null;
        try {
            Cipher cipher = JvmSupportManager.getJvmSupportInterface().getCipherFor(CipherAlgorithm);
            cipher.init(2, key);
            decryptedBytes = cipher.doFinal(encryptedBytes);
        }
        catch (Exception e) {
            Message msg = new Message("G0099E.ERROR_DECRYPTING_DATA");
            ExtendedException ee = new ExtendedException(msg, (Throwable)e);
            throw ee;
        }
        return decryptedBytes;
    }

    public static void loadDefaultKey(String fileName) throws IOException, Exception {
        File file = new File(fileName);
        if (file.exists()) {
            defaultKey = Encryption.readKeyFromFile(fileName);
        } else {
            SecretKey key = Encryption.generateKey(null);
            Encryption.writeKeyToFile(fileName, key);
            defaultKey = key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Key readKeyFromFile(String fileName) throws IOException, InvalidArgumentException {
        SecretKeySpec key = null;
        FileInputStream is = null;
        try {
            is = new FileInputStream(fileName);
            key = Encryption.readKeyFromStream(is);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return key;
    }

    public static SecretKeySpec readKeyFromStream(InputStream is) throws IOException, InvalidArgumentException {
        byte[] keyBytes = FileUtils.readStream(is);
        String base64String = new String(keyBytes, 0, keyBytes.length, "UTF-8");
        SecretKeySpec key = Encryption.readKeyFromString(base64String);
        return key;
    }

    public static SecretKeySpec readKeyFromString(String base64EncodedKey) throws InvalidArgumentException {
        char[] chars = new char[base64EncodedKey.length()];
        base64EncodedKey.getChars(0, base64EncodedKey.length(), chars, 0);
        byte[] decodedBytes = Base64.decode(chars, chars.length);
        SecretKeySpec key = new SecretKeySpec(decodedBytes, CipherAlgorithm);
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readKeyAsStringFromFile(String fileName) throws IOException {
        FileInputStream is = null;
        String base64String = null;
        try {
            is = new FileInputStream(fileName);
            byte[] keyBytes = FileUtils.readStream(is);
            base64String = new String(keyBytes, 0, keyBytes.length, "UTF-8");
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return base64String;
    }

    public static SecretKey generateKey(String seed) throws Exception {
        KeyGenerator keyGenerator = JvmSupportManager.getJvmSupportInterface().getKeyGeneratorFor(CipherAlgorithm);
        SecureRandom secureRandom = JvmSupportManager.getJvmSupportInterface().getSecureRandom();
        if (seed != null && seed.length() > 0) {
            secureRandom.setSeed(seed.getBytes());
        }
        keyGenerator.init(128, secureRandom);
        SecretKey key = keyGenerator.generateKey();
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeKeyToFile(String fileName, Key key) throws IOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(fileName);
            Encryption.writeKeyToStream(os, key);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static void writeKeyToStream(OutputStream os, Key key) throws IOException {
        String base64EncodedKey = Encryption.writeKeyToString(key);
        os.write(base64EncodedKey.getBytes("UTF-8"));
    }

    public static String writeKeyToString(Key key) {
        byte[] keyBytes = key.getEncoded();
        String base64EncodedKey = Base64.encode(keyBytes);
        return base64EncodedKey;
    }

    public static void loadDefaultKeyForJUnitEnvironment() {
        defaultKey = new SecretKeySpec(JUnitByteKey, CipherAlgorithm);
    }
}

