/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util;

import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryExplorer {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private String currentDirectory;
    private static final String parentDirectory = "[..]";
    private static final String windowsRoot = "\\\\";
    private static final String unixRoot = "/";

    public DirectoryExplorer(String currentDirectory) {
        this.currentDirectory = currentDirectory == null || currentDirectory.equals("") ? DirectoryExplorer.getVirtualRoot() : currentDirectory;
    }

    public Vector<String> getDirectories() {
        if (this.currentDirectory.equals(windowsRoot)) {
            return DirectoryExplorer.getRoots();
        }
        File file = new File(this.currentDirectory);
        Vector<String> directories = new Vector<String>();
        String[] files = file.list();
        if (files == null) {
            return null;
        }
        for (int i = 0; i < files.length; ++i) {
            File f;
            if (files[i].equals(".") || files[i].equals("..") || !(f = new File(this.currentDirectory + File.separator + files[i])).isDirectory() || f.isHidden()) continue;
            directories.add(files[i]);
        }
        Collections.sort(directories);
        if (!this.currentDirectory.equals(unixRoot)) {
            directories.insertElementAt(parentDirectory, 0);
        }
        return directories;
    }

    public boolean isValidDir() {
        if (this.currentDirectory == null) {
            return false;
        }
        if (this.currentDirectory.equals(windowsRoot)) {
            return true;
        }
        File file = new File(this.currentDirectory);
        return file.exists() && file.isDirectory();
    }

    public void changeDirectory(String subDirectory) {
        File f;
        String parent;
        this.currentDirectory = subDirectory.equals(parentDirectory) ? ((parent = (f = new File(this.currentDirectory)).getParent()) != null ? parent : windowsRoot) : (this.currentDirectory.equals(unixRoot) ? this.currentDirectory + subDirectory : (this.currentDirectory.equals(windowsRoot) ? subDirectory : (DirectoryExplorer.getRoots().contains(this.currentDirectory) ? this.currentDirectory + subDirectory : this.currentDirectory + File.separator + subDirectory)));
    }

    public String getCurrentDirectory() {
        if (this.currentDirectory.equals(windowsRoot)) {
            return "";
        }
        return this.currentDirectory;
    }

    public LinkedList<String> getHierarchy() {
        LinkedList<String> hierarchy = new LinkedList<String>();
        for (File f = new File(this.currentDirectory).getParentFile(); f != null; f = f.getParentFile()) {
            hierarchy.addFirst(f.getPath());
        }
        return hierarchy;
    }

    public static Vector<String> getRoots() {
        File[] roots = File.listRoots();
        Vector<String> rootStrings = new Vector<String>(roots.length);
        for (int i = 0; i < roots.length; ++i) {
            rootStrings.add(roots[i].getPath());
        }
        return rootStrings;
    }

    public static String getVirtualRoot() {
        if (DirectoryExplorer.getRoots().firstElement().equals(unixRoot)) {
            return unixRoot;
        }
        return windowsRoot;
    }
}

