/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateParser {
    private static final DateFormat PATTERN_DEFAULT = DateFormat.getDateTimeInstance();
    private static final SimpleDateFormat PATTERN_ASCTIME = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", Locale.US);
    private static final SimpleDateFormat PATTERN_RFC850 = new SimpleDateFormat("EEEE, dd-MMM-yy HH:mm:ss z", Locale.US);
    private static final SimpleDateFormat PATTERN_RFC1123 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
    private static final SimpleDateFormat PATTERN_ISO8601 = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat PATTERN_RFC850_ALT = new SimpleDateFormat("EEEE, dd-MMM-yy HH:mm:ss", Locale.US);
    private static final SimpleDateFormat PATTERN_RFC1123_ALT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss", Locale.US);
    private static final SimpleDateFormat PATTERN_MSOFFICE = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss", Locale.US);
    private static final DateFormat[] FORMATS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parse(String dateValue) throws ParseException {
        if (dateValue == null) {
            throw new ParseException("date string was null", 0);
        }
        String dateString = dateValue.trim();
        if (dateString.length() < 4) {
            throw new ParseException("date string too short", 0);
        }
        ParseException pe = null;
        for (DateFormat format : FORMATS) {
            try {
                DateFormat dateFormat = format;
                synchronized (dateFormat) {
                    return format.parse(dateString);
                }
            }
            catch (ParseException e) {
                if (pe != null) continue;
                pe = e;
            }
        }
        throw pe;
    }

    public static long parseDate(String dateValue) throws ParseException {
        return DateParser.parse(dateValue).getTime();
    }

    public static String format(long epoctime) {
        return DateParser.format(new Date(epoctime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(Date date) {
        SimpleDateFormat simpleDateFormat = PATTERN_RFC1123;
        synchronized (simpleDateFormat) {
            PATTERN_RFC1123.setTimeZone(TimeZone.getDefault());
            return PATTERN_RFC1123.format(date);
        }
    }

    static {
        PATTERN_MSOFFICE.setTimeZone(TimeZone.getTimeZone("GMT"));
        FORMATS = new DateFormat[]{PATTERN_RFC1123, PATTERN_RFC850, PATTERN_ASCTIME, PATTERN_ISO8601, PATTERN_RFC1123_ALT, PATTERN_RFC850_ALT, PATTERN_MSOFFICE, PATTERN_DEFAULT};
    }
}

