/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.util.Encryption;
import java.security.Key;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class CryptionUtil {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public static String encrypt(String plainText, String key) throws ExtendedException {
        SecretKeySpec aKey = Encryption.readKeyFromString(key);
        return Encryption.encrypt(plainText, (Key)aKey);
    }

    public static String decrypt(String encryptedText, String key) throws ExtendedException {
        SecretKeySpec aKey = Encryption.readKeyFromString(key);
        return Encryption.decrypt(encryptedText, (Key)aKey);
    }

    public static String generateKey(String seed) throws Exception {
        SecretKey key = Encryption.generateKey(seed);
        return Encryption.writeKeyToString(key);
    }

    public static void main(String[] args) {
        String seed = null;
        String input = null;
        if (args.length >= 2) {
            seed = args[0];
            input = args[1];
        } else {
            seed = "testkey";
            input = "testpass";
        }
        try {
            String key = CryptionUtil.generateKey(seed);
            System.out.println("Key length " + key.length());
            String cryptText = CryptionUtil.encrypt(input, key);
            System.out.println("Input Plain Text " + input);
            System.out.println("Encrypted Text " + cryptText);
            String plainText = CryptionUtil.decrypt(cryptText, key);
            System.out.println("Plain Text " + plainText);
            if (plainText.equals(input)) {
                System.out.println("Test Successful");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

