/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util;

import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountingSemaphore {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private volatile int notifiesNeeded = 0;
    private volatile Vector<Object> notificationObjects = null;

    public CountingSemaphore(int numberOfNotifiesNeeded) {
        this.notifiesNeeded = numberOfNotifiesNeeded;
        this.notificationObjects = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAllNotifiers() throws InterruptedException {
        Vector<Object> vector = this.notificationObjects;
        synchronized (vector) {
            while (this.notifiesNeeded > 0) {
                this.notificationObjects.wait();
            }
        }
    }

    public void notifyFinished() {
        this.notifyFinished(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyFinished(Object objectForWaiter) {
        Vector<Object> vector = this.notificationObjects;
        synchronized (vector) {
            if (objectForWaiter != null) {
                this.notificationObjects.add(objectForWaiter);
            }
            --this.notifiesNeeded;
            this.notificationObjects.notify();
        }
    }

    public Vector<Object> getNotificationObjects() {
        return this.notificationObjects;
    }
}

