/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.common.ReleaseInfo;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.configuration.JettyConfiguration;
import com.ibm.es.nuvo.util.AuthUtils;
import com.ibm.es.nuvo.util.Base64;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ConfigTool {
    private String _configDir = null;
    private static final String AuthFileName = "authentication.xml";
    private static final String KeyFileName = "key.txt";
    private static String MonitorURL = "/whitney/inyo/monitor";
    private String _host = "localhost";
    private int _port = 10000;

    public ConfigTool(String cfgdir) throws IOException, ParserConfigurationException, SAXException {
        this._configDir = cfgdir;
        this.init();
    }

    public void init() throws IOException, ParserConfigurationException, SAXException {
        this.initJettyPort();
    }

    protected String getAuthFile() {
        String authFileName = this._configDir + File.separator + AuthFileName;
        return authFileName;
    }

    protected String getKeyFile() {
        String keyFileName = this._configDir + File.separator + KeyFileName;
        return keyFileName;
    }

    public void initJettyPort() throws IOException, ParserConfigurationException, SAXException {
        JettyConfiguration jettyConfig = new JettyConfiguration(GlobalConfiguration.getConfiguration());
        this._port = jettyConfig.getAdminHttpPort();
    }

    protected boolean isServerUp() {
        try {
            String authFname = this.getAuthFile();
            String keyFname = this.getKeyFile();
            File keyFile = new File(keyFname);
            if (!keyFile.exists()) {
                System.err.println("No Key file exists to print authentication ");
                return false;
            }
            String auth = AuthUtils.getCurrentAuth(keyFname, authFname);
            if (auth == null) {
                return false;
            }
            return this.checkRunning(auth);
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected boolean checkRunning(String authToken) throws IOException, Exception {
        try {
            String auth = ":" + authToken;
            byte[] data = auth.getBytes("UTF-8");
            String base64Auth = Base64.encode(data);
            URL url = new URL("http", this._host, this._port, MonitorURL);
            HttpURLConnection _connection = (HttpURLConnection)url.openConnection();
            _connection.setDoInput(true);
            _connection.setDoOutput(true);
            _connection.setRequestMethod("POST");
            _connection.addRequestProperty("action", "getStatus");
            _connection.addRequestProperty("scope", "system");
            _connection.addRequestProperty("Authorization", "Basic " + base64Auth);
            int code = _connection.getResponseCode();
            if (code == 200) {
                return true;
            }
            if (code == 500 || code == 401 || code == 404) {
                System.err.println(" Code " + code + " while checking system status request ");
                return true;
            }
            return false;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw e;
        }
    }

    public void printKeyAuthentication() {
        String keyFileName = this.getKeyFile();
        File keyFile = new File(keyFileName);
        if (!keyFile.exists()) {
            System.err.println("No Key file exists to print authentication ");
            return;
        }
        try {
            String authFileName = this.getAuthFile();
            String apiPass = AuthUtils.getCurrentAuth(keyFileName, authFileName);
            String key = AuthUtils.getKey(keyFileName);
            Message msg = new Message("D0024I.GEN_AUTHTOKEN");
            System.out.println(msg.getFormattedText());
            System.out.println(apiPass);
            msg = new Message("D0025I.GEN_ENCKEY");
            System.out.println(msg.getFormattedText());
            System.out.println(key);
            return;
        }
        catch (Exception ex) {
            System.err.println("Failed to print current authentication values");
            ex.printStackTrace();
            return;
        }
    }

    protected static boolean checkConfigDir(String cfgDir) {
        File configDirectory = new File(cfgDir);
        if (!configDirectory.exists()) {
            Message msg = new Message("G0040E.CONFIG_DIRECTORY_DOES_NOT_EXIST", cfgDir);
            System.err.println(msg.getFormattedText());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean generateAuthentication(String seed) {
        String authFileName = this.getAuthFile();
        try {
            if (this.isServerUp()) {
                System.err.println(" The genToken command could not be executed ");
                Message msg = new Message("D0025E.DIR_ALREADY_USED_BY_RUNNING_SERVER", authFileName);
                System.out.println(msg.getFormattedText());
                return false;
            }
            boolean init = false;
            String keyFileName = this.getKeyFile();
            File keyFile = new File(keyFileName);
            if (!keyFile.exists()) {
                init = true;
            }
            if (!init) {
                AuthUtils.getCurrentAuth(keyFileName, authFileName);
            }
            AuthUtils.generateKeyFile(seed, keyFileName);
            AuthUtils.generateAuth(seed, keyFileName, authFileName);
            return true;
        }
        catch (IOException ioe) {
            System.err.println(" IO error with key.txt or authentication.xml");
            ioe.printStackTrace();
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static void usage() {
        String s = "Usage : ConfigTool [options] ";
        String opt1 = " option can be --genToken <seed> to generate authentication";
        String opt2 = " option can be --printToken to print current authentication";
        System.out.println(s);
        System.out.println(opt1);
        System.out.println(opt2);
    }

    public static void main(String[] args) {
        block12: {
            if (args.length < 2) {
                ConfigTool.usage();
                return;
            }
            String cfgDir = null;
            try {
                String cfgXml = args[0];
                File cfgFile = new File(cfgXml);
                if (!cfgFile.exists() || !cfgFile.isFile()) {
                    System.err.println("Invalid config Xml " + cfgXml);
                    return;
                }
                GlobalConfiguration.initialize(cfgXml);
                cfgDir = GlobalConfiguration.getConfiguration().getConfigPath();
                if (!ConfigTool.checkConfigDir(cfgDir)) {
                    return;
                }
                ReleaseInfo.initialize(null);
            }
            catch (Exception ex) {
                System.err.println("ConfigTool: Init error");
                return;
            }
            String cmd = args[1];
            try {
                ConfigTool cfgUtil = new ConfigTool(cfgDir);
                if (cmd.equals("--help") || cmd.equals("-h")) {
                    ConfigTool.usage();
                    return;
                }
                if (cmd.equals("--genToken")) {
                    if (args.length < 3) {
                        ConfigTool.usage();
                        return;
                    }
                    String seed = args[2];
                    if (!cfgUtil.generateAuthentication(seed)) {
                        return;
                    }
                    cfgUtil.printKeyAuthentication();
                    break block12;
                }
                if (cmd.equals("--printToken")) {
                    cfgUtil.printKeyAuthentication();
                    break block12;
                }
                ConfigTool.usage();
                return;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

