/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util;

import java.util.Hashtable;

public class CommandLineArguments {
    private Hashtable<String, String> hashTable = null;

    public CommandLineArguments(String[] args) {
        this.hashTable = new Hashtable(args.length);
        this.processArgs(args);
    }

    private void processArgs(String[] args) {
        if (null == args) {
            return;
        }
        for (int i = 0; i < args.length - 1; ++i) {
            String curArg = args[i];
            String potentialValue = args[i + 1];
            if (!curArg.startsWith("-")) continue;
            String value = potentialValue;
            if (!potentialValue.startsWith("-")) {
                ++i;
            } else {
                try {
                    Long.parseLong(potentialValue);
                    ++i;
                }
                catch (NumberFormatException e) {
                    value = "";
                }
            }
            if (curArg.startsWith("--")) {
                this.hashTable.put(curArg.substring(2), value);
                continue;
            }
            this.hashTable.put(curArg.substring(1), value);
        }
    }

    public String getMissingRequiredParam(String[] requiredParams) {
        for (String required : requiredParams) {
            if (this.doesParamExist(required)) continue;
            return required;
        }
        return null;
    }

    public String getParam(String parameter) {
        if (null == parameter) {
            return null;
        }
        return this.hashTable.get(parameter);
    }

    public boolean doesParamExist(String parameter) {
        if (null == parameter) {
            return false;
        }
        return this.hashTable.containsKey(parameter);
    }

    public int getParamsCount() {
        return this.hashTable.size();
    }
}

