/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util;

import com.ibm.es.nuvo.util.StreamUtils;
import com.ibm.es.nuvo.util.XMLTagger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinedXMLData {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String CombinedDataElement = "combined_xml_data";
    protected static final String StartXMLHeader = "<?xml";
    protected static final String EndXMLHeader = "?>";
    private static final String StartDOCTYPEHeader = "<!DOCTYPE";
    private static final String EndDOCTYPEHeader = ">";

    public static void writeTo(OutputStream os, Vector<String> elementNames, Vector<String> xmlDocs) throws IOException {
        XMLTagger tagger = new XMLTagger(true);
        tagger.startPI("xml");
        tagger.writeAttr("version", "1.0");
        tagger.writeAttr("encoding", "UTF-8");
        tagger.endPI();
        tagger.openStartElement(CombinedDataElement);
        tagger.writeAttr("version", "1.0");
        tagger.closeTag();
        for (int i = 0; i < elementNames.size(); ++i) {
            tagger.startElement(elementNames.elementAt(i));
            String docWithNoHeader = CombinedXMLData.stripHeader(StartXMLHeader, EndXMLHeader, xmlDocs.get(i));
            String docWithNoDoctype = CombinedXMLData.stripHeader(StartDOCTYPEHeader, EndDOCTYPEHeader, docWithNoHeader);
            tagger.writeXMLFragment(docWithNoDoctype);
            tagger.endElement(elementNames.elementAt(i));
        }
        tagger.endElement(CombinedDataElement);
        String xml = tagger.getXML();
        os.write(xml.getBytes("UTF-8"));
    }

    public static HashMap<String, String> loadDocumentsFrom(InputStream is, Vector<String> elementNames) throws IOException, InterruptedException {
        HashMap<String, String> outputDocuments = new HashMap<String, String>();
        String xmlDoc = StreamUtils.getStreamDataAsString(is, "UTF-8");
        String xmlHeader = CombinedXMLData.buildXMLHeader();
        for (int i = 0; i < elementNames.size(); ++i) {
            String key = elementNames.get(i);
            String startXMLElement = "<" + key + EndDOCTYPEHeader;
            String endXMLElement = "</" + key + EndDOCTYPEHeader;
            String doc = CombinedXMLData.getDocument(xmlDoc, startXMLElement, endXMLElement, xmlHeader);
            outputDocuments.put(key, doc);
        }
        return outputDocuments;
    }

    protected static String stripHeader(String startTag, String endTag, String xmlDoc) {
        String docWithNoHeader = xmlDoc;
        int startIndex = xmlDoc.indexOf(startTag);
        int endIndex = xmlDoc.indexOf(endTag);
        if (startIndex >= 0 && endIndex > 0 && startIndex < endIndex) {
            docWithNoHeader = xmlDoc.length() > endIndex + endTag.length() ? xmlDoc.substring(endIndex + endTag.length()) : "";
        }
        return docWithNoHeader;
    }

    private static String getDocument(String xmlDoc, String startXMLElement, String endXMLElement, String xmlHeader) {
        String strDoc = null;
        int startIndex = xmlDoc.indexOf(startXMLElement);
        int endIndex = xmlDoc.indexOf(endXMLElement);
        if (startIndex >= 0 && endIndex > 0 && startIndex + startXMLElement.length() < endIndex) {
            StringBuilder doc = new StringBuilder(30000);
            if (xmlHeader != null) {
                doc.append(xmlHeader);
            }
            doc.append(xmlDoc.substring(startIndex + startXMLElement.length(), endIndex));
            strDoc = doc.toString();
        }
        return strDoc;
    }

    private static String buildXMLHeader() {
        XMLTagger xmlTagger = new XMLTagger(true);
        xmlTagger.startPI("xml");
        xmlTagger.writeAttr("version", "1.0");
        xmlTagger.writeAttr("encoding", "UTF-8");
        xmlTagger.endPI();
        String xmlHeader = xmlTagger.getXML();
        return xmlHeader;
    }
}

