/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class BufferedRandomAcessFileReader {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private byte[] bufferedBytes = null;
    private RandomAccessFile file = null;
    private int curByteReadPosition = -1;
    private int bufferedCount = 0;

    public BufferedRandomAcessFileReader(File fileToRead) throws FileNotFoundException {
        this(fileToRead, 4096);
    }

    public BufferedRandomAcessFileReader(File fileToRead, int bufferSize) throws FileNotFoundException, IllegalArgumentException {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("invalid buffer size: " + bufferSize);
        }
        this.bufferedBytes = new byte[bufferSize];
        this.file = new RandomAccessFile(fileToRead, "r");
    }

    public long length() throws IOException {
        return this.file.length();
    }

    public void seek(long pos) throws IOException {
        this.file.seek(pos);
        this.curByteReadPosition = -1;
        this.bufferedCount = 0;
    }

    public void close() throws IOException {
        this.file.close();
    }

    public int read() throws IOException {
        if (this.bufferedCount <= 0) {
            this.bufferedCount = this.file.read(this.bufferedBytes, 0, this.bufferedBytes.length);
            if (this.bufferedCount <= 0) {
                return this.bufferedCount;
            }
            this.curByteReadPosition = 0;
        }
        byte retByte = this.bufferedBytes[this.curByteReadPosition];
        ++this.curByteReadPosition;
        if (this.curByteReadPosition == this.bufferedCount) {
            this.curByteReadPosition = -1;
            this.bufferedCount = 0;
        }
        return retByte;
    }

    public long getFilePointer() throws IOException {
        long filePointer = this.file.getFilePointer();
        if (this.curByteReadPosition > 0) {
            filePointer = filePointer - (long)this.bufferedCount + (long)this.curByteReadPosition;
        }
        return filePointer;
    }
}

