/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util;

import com.ibm.es.nuvo.common.InvalidArgumentException;

public class Base64 {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final char FILLCHAR = '=';
    private static final char[] ALPHABET = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final char[] SAFE_ALPHABET = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};

    private static byte decode(char ch) throws InvalidArgumentException {
        if (ch >= 'A' && ch <= 'Z') {
            return (byte)(ch - 65);
        }
        if (ch >= 'a' && ch <= 'z') {
            return (byte)(ch - 97 + 26);
        }
        if (ch >= '0' && ch <= '9') {
            return (byte)(ch - 48 + 52);
        }
        if (ch == '+') {
            return 62;
        }
        if (ch == '/') {
            return 63;
        }
        throw new InvalidArgumentException("char", String.valueOf(ch));
    }

    private static int encodeSize(int sourceLength) {
        return 4 * ((sourceLength + 2) / 3);
    }

    private static int decodeSize(int sourceLength) {
        return 3 * ((sourceLength + 3) / 4);
    }

    public static String encode(byte[] source) {
        return Base64.encode(source, source.length, false);
    }

    private static String encode(byte[] source, int sourceLength, boolean safe) {
        int destSize = sourceLength * 3;
        char[] baseChars = null;
        baseChars = safe ? SAFE_ALPHABET : ALPHABET;
        StringBuffer buf = new StringBuffer(destSize);
        int loop = source.length - source.length % 3;
        int i = 0;
        for (i = 0; i < loop; i += 3) {
            buf.append(baseChars[(source[i] & 0xFC) >> 2]);
            buf.append(baseChars[(source[i] & 3) << 4 | (source[i + 1] & 0xF0) >> 4]);
            buf.append(baseChars[(source[i + 1] & 0xF) << 2 | (source[i + 2] & 0xC0) >> 6]);
            buf.append(baseChars[source[i + 2] & 0x3F]);
        }
        if (i < source.length) {
            buf.append(baseChars[(source[i] & 0xFC) >> 2]);
            if (loop == source.length - 1) {
                buf.append(baseChars[(source[i] & 3) << 4]);
                buf.append("==");
            } else {
                buf.append(baseChars[(source[i] & 3) << 4 | (source[i + 1] & 0xF0) >> 4]);
                buf.append(baseChars[(source[i + 1] & 0xF) << 2]);
                buf.append("=");
            }
        }
        return buf.toString();
    }

    public static byte[] decode(char[] source, int sourceLength) throws InvalidArgumentException {
        int sourcePos;
        byte[] dest = new byte[sourceLength * 3];
        int destPos = 0;
        int destTemp = 0;
        for (sourcePos = 0; sourcePos < sourceLength; ++sourcePos) {
            int bitPos = sourcePos * 6 % 8;
            char ch = source[sourcePos];
            if (ch == '=') {
                if (bitPos != 0 && bitPos != 6) {
                    if (bitPos == 4) {
                        if (sourcePos + 1 >= sourceLength || source[sourcePos + 1] != '=') {
                            throw new InvalidArgumentException("fillChar");
                        }
                        sourcePos += 2;
                    } else {
                        ++sourcePos;
                    }
                }
                if (destTemp != 0) {
                    throw new InvalidArgumentException("destTemp", String.valueOf(destTemp));
                }
                if (sourcePos == sourceLength) break;
                throw new InvalidArgumentException("sourceLength", String.valueOf(sourceLength));
            }
            byte bits = Base64.decode(ch);
            if (bitPos == 0) {
                destTemp = (byte)(bits << 2);
                continue;
            }
            if (bitPos == 6) {
                dest[destPos] = destTemp = (int)((byte)(destTemp | bits >> 4));
                ++destPos;
                destTemp = (byte)(bits << 4);
                continue;
            }
            if (bitPos == 4) {
                dest[destPos] = destTemp = (int)((byte)(destTemp | bits >> 2));
                ++destPos;
                destTemp = (byte)(bits << 6);
                continue;
            }
            dest[destPos] = destTemp = (int)((byte)(destTemp | bits));
            ++destPos;
        }
        if (sourcePos % 4 != 0) {
            throw new InvalidArgumentException("sourcePosAlignment", String.valueOf(sourcePos));
        }
        byte[] result = new byte[destPos];
        System.arraycopy(dest, 0, result, 0, destPos);
        return result;
    }
}

