/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.util;

import com.ibm.es.nuvo.authentication.AuthenticationData;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.jvm.JvmSupportManager;
import com.ibm.es.nuvo.util.Base64;
import com.ibm.es.nuvo.util.Encryption;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Random;
import javax.crypto.SecretKey;

public class AuthUtils {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public static void generateKeyFile(String seed, String keyfname) throws GeneralSecurityException, Exception {
        try {
            SecretKey key = Encryption.generateKey(seed);
            Encryption.writeKeyToFile(keyfname, key);
        }
        catch (GeneralSecurityException e) {
            throw new ExtendedException(e);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public static String generateApiPassword(String seed) throws ExtendedException {
        String pwd = null;
        try {
            SecureRandom secureRandom = JvmSupportManager.getJvmSupportInterface().getSecureRandom();
            Random random = new Random();
            if (seed != null && seed.length() > 0) {
                byte[] seedBytes = seed.getBytes();
                secureRandom.setSeed(seedBytes);
                random.setSeed(seedBytes[0]);
            }
            int pwdSize = 4 + random.nextInt(2);
            byte[] randomBytes = new byte[pwdSize];
            secureRandom.nextBytes(randomBytes);
            pwd = Base64.encode(randomBytes);
        }
        catch (Exception e) {
            throw new ExtendedException(e);
        }
        return pwd;
    }

    public static String generateAuth(String seed, String keyFname, String authFname) {
        AuthenticationData authData = new AuthenticationData();
        FileOutputStream fos = null;
        try {
            Encryption.loadDefaultKey(keyFname);
            String passwd = AuthUtils.generateApiPassword(seed);
            authData.setApiPassword(passwd);
            fos = new FileOutputStream(authFname);
            authData.writeTo(fos);
            fos.close();
            return passwd;
        }
        catch (IOException ioe) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getKey(String keyFname) {
        try {
            String key = Encryption.readKeyAsStringFromFile(keyFname);
            return key;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getCurrentAuth(String keyFname, String authFname) {
        AuthenticationData authData = new AuthenticationData();
        FileInputStream fis = null;
        String apiPass = null;
        try {
            Encryption.loadDefaultKey(keyFname);
            fis = new FileInputStream(new File(authFname));
            authData.loadFrom(fis);
            apiPass = authData.getApiPassword();
            fis.close();
            return apiPass;
        }
        catch (Exception ex) {
            System.err.println("Failed to get current authentication values");
            ex.printStackTrace();
            return null;
        }
    }
}

