/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer.uima;

import com.ibm.es.nuvo.parser.XMLTextBuffers;
import com.ibm.es.nuvo.tokenizer.XMLToken;
import com.ibm.uima.cas.impl.LowLevelCAS;
import com.ibm.uima.cas.impl.LowLevelIndexRepository;
import com.ibm.uima.cas.impl.LowLevelTypeSystem;
import com.ibm.uima.cas.text.TCAS;

public class XMLLowLevelCASSupport {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private int valueOffsetShift = -1;
    private TCAS tcas;
    private LowLevelCAS llc;
    private LowLevelIndexRepository llir;
    private LowLevelTypeSystem llts;
    private XMLTextBuffers xmlTextBuffers;
    private static final String[] names = new String[]{"uima.tt.XMLTagAnnotation", "uima.tt.XMLAttrAnnotation", "uima.tcas.Annotation:begin", "uima.tcas.Annotation:end", "uima.tt.XMLTagAnnotation:name", "uima.tt.XMLTagAnnotation:serial", "uima.tt.XMLTagAnnotation:lastDescendant", "uima.tt.XMLTagAnnotation:depth", "uima.tt.XMLTagAnnotation:tokenBegin", "uima.tt.XMLTagAnnotation:tokenEnd"};
    private int[] codes = null;

    public XMLLowLevelCASSupport(TCAS tcas) {
        int j;
        this.tcas = tcas;
        this.llc = this.tcas.getLowLevelCAS();
        this.llts = this.llc.ll_getTypeSystem();
        this.llir = this.llc.ll_getIndexRepository();
        int[] tmpCodes = new int[names.length];
        for (j = 0; j < 2; ++j) {
            tmpCodes[j] = this.llts.ll_getCodeForTypeName(names[j]);
        }
        for (j = 2; j < tmpCodes.length; ++j) {
            tmpCodes[j] = this.llts.ll_getCodeForFeatureName(names[j]);
        }
        this.codes = tmpCodes;
    }

    TCAS getTCAS() {
        return this.tcas;
    }

    XMLTextBuffers getXMLTextBuffers() {
        return this.xmlTextBuffers;
    }

    void setXMLTextBuffers(XMLTextBuffers xtb) {
        this.xmlTextBuffers = xtb;
        this.valueOffsetShift = -1;
    }

    int getValueOffsetShift() {
        if (this.valueOffsetShift < 0) {
            if (this.xmlTextBuffers == null) {
                return 0;
            }
            CharSequence cs = this.xmlTextBuffers.getXMLBuffer(0);
            this.valueOffsetShift = cs == null ? 0 : cs.length() + "\n\n".length();
        }
        return this.valueOffsetShift;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("XLLCS[ ");
        sb.append(" tcas=" + this.tcas);
        sb.append(" llc=" + this.llc);
        sb.append(" llts=" + this.llts);
        sb.append(" llir=" + this.llir);
        for (int j = 0; j < this.codes.length; ++j) {
            sb.append(" code=" + this.codes[j]);
        }
        sb.append(" ]");
        return sb.toString();
    }

    public class Attr
    extends Tag {
        public Attr() {
            super(false);
            this.addr = XMLLowLevelCASSupport.this.llc.ll_createFS(XMLLowLevelCASSupport.this.codes[1]);
        }

        public Attr(int addr) {
            super(addr);
        }

        public CharSequence getAttributeValue() {
            CharSequence cs;
            int vos = XMLLowLevelCASSupport.this.getValueOffsetShift();
            int begin = this.getTagAttrBegin() - vos;
            int end = this.getTagAttrEnd() - vos;
            if (begin >= 0 && end >= 0 && end > begin && XMLLowLevelCASSupport.this.xmlTextBuffers != null && (cs = XMLLowLevelCASSupport.this.xmlTextBuffers.getXMLBuffer(1)) != null && cs.length() > 0) {
                return cs.subSequence(begin, end);
            }
            return null;
        }

        public boolean isAttr() {
            return true;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("XLLCS.Att[");
            sb.append(super.toString());
            sb.append(" vs=" + this.getAttributeValue());
            sb.append(" ]");
            return sb.toString();
        }
    }

    public class Tag
    extends XMLToken {
        protected int addr;
        protected int tokenZero;

        public Tag() {
            this.addr = XMLLowLevelCASSupport.this.llc.ll_createFS(XMLLowLevelCASSupport.this.codes[0]);
        }

        protected Tag(int addr) {
            this.addr = addr;
        }

        protected Tag(boolean dummy) {
        }

        public void addToIndex() {
            XMLLowLevelCASSupport.this.llir.ll_addFS(this.addr);
        }

        public int getTagAttrBegin() {
            return XMLLowLevelCASSupport.this.llc.ll_getIntValue(this.addr, XMLLowLevelCASSupport.this.codes[2]);
        }

        public void setTagAttrBegin(int b) {
            XMLLowLevelCASSupport.this.llc.ll_setIntValue(this.addr, XMLLowLevelCASSupport.this.codes[2], b);
        }

        public int getTagAttrEnd() {
            return XMLLowLevelCASSupport.this.llc.ll_getIntValue(this.addr, XMLLowLevelCASSupport.this.codes[3]);
        }

        public void setTagAttrEnd(int e) {
            XMLLowLevelCASSupport.this.llc.ll_setIntValue(this.addr, XMLLowLevelCASSupport.this.codes[3], e);
        }

        public String getTagAttrName() {
            return XMLLowLevelCASSupport.this.llc.ll_getStringValue(this.addr, XMLLowLevelCASSupport.this.codes[4]);
        }

        public void setTagAttrName(String newName) {
            XMLLowLevelCASSupport.this.llc.ll_setStringValue(this.addr, XMLLowLevelCASSupport.this.codes[4], newName);
        }

        public int getTagAttrSerial() {
            return XMLLowLevelCASSupport.this.llc.ll_getIntValue(this.addr, XMLLowLevelCASSupport.this.codes[5]);
        }

        public void setTagAttrSerial(int s) {
            XMLLowLevelCASSupport.this.llc.ll_setIntValue(this.addr, XMLLowLevelCASSupport.this.codes[5], s);
        }

        public int getTagAttrLastDescendant() {
            return XMLLowLevelCASSupport.this.llc.ll_getIntValue(this.addr, XMLLowLevelCASSupport.this.codes[6]);
        }

        public void setTagAttrLastDescendant(int ld) {
            XMLLowLevelCASSupport.this.llc.ll_setIntValue(this.addr, XMLLowLevelCASSupport.this.codes[6], ld);
        }

        public int getTagAttrDepth() {
            return XMLLowLevelCASSupport.this.llc.ll_getIntValue(this.addr, XMLLowLevelCASSupport.this.codes[7]);
        }

        public void setTagAttrDepth(int d) {
            XMLLowLevelCASSupport.this.llc.ll_setIntValue(this.addr, XMLLowLevelCASSupport.this.codes[7], d);
        }

        public int getTagAttrTokenBegin() {
            return XMLLowLevelCASSupport.this.llc.ll_getIntValue(this.addr, XMLLowLevelCASSupport.this.codes[8]);
        }

        public void setTagAttrTokenBegin(int tb) {
            XMLLowLevelCASSupport.this.llc.ll_setIntValue(this.addr, XMLLowLevelCASSupport.this.codes[8], tb);
        }

        public int getTagAttrTokenEnd() {
            return XMLLowLevelCASSupport.this.llc.ll_getIntValue(this.addr, XMLLowLevelCASSupport.this.codes[9]);
        }

        public void setTagAttrTokenEnd(int te) {
            XMLLowLevelCASSupport.this.llc.ll_setIntValue(this.addr, XMLLowLevelCASSupport.this.codes[9], te);
        }

        public int getTagAttrTokenZero() {
            return this.tokenZero;
        }

        public void setTagAttrTokenZero(int tz) {
            this.tokenZero = tz;
        }

        public boolean isAttr() {
            return false;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("XLLCS.Tag[");
            sb.append(" nam=" + this.getTagAttrName());
            sb.append(" cb=" + this.getTagAttrBegin());
            sb.append(" ce=" + this.getTagAttrEnd());
            sb.append(" tb=" + this.getTagAttrTokenBegin());
            sb.append(" te=" + this.getTagAttrTokenEnd());
            sb.append(" tz=" + this.tokenZero);
            sb.append(" dep=" + this.getTagAttrDepth());
            sb.append(" ]");
            return sb.toString();
        }
    }
}

