/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer.uima;

import com.ibm.es.nuvo.tokenizer.uima.TokenIterator;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WildcardTokenIterator
implements TokenIterator {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private TokenIterator iterator;
    private TokenGroup buffer;
    private int previousEnd;
    private boolean eoi;
    private CharSequence lastOriginal;
    private List<CharSequence> lastLemmas;
    private TokenIterator.TokenType lastType;
    private EnumSet<TokenIterator.TokenProperty> lastProps;
    private int lastBegin;
    private int lastEnd;

    WildcardTokenIterator(TokenIterator it) {
        this(it, 4);
    }

    WildcardTokenIterator(TokenIterator it, int capacity) {
        this.iterator = it;
        this.buffer = new TokenGroup(capacity);
        this.lastOriginal = null;
        this.previousEnd = 0;
        this.eoi = false;
    }

    @Override
    public CharSequence getLemma() {
        return this.buffer.getLemma();
    }

    @Override
    public List<CharSequence> getLemmas(List<CharSequence> list) {
        return this.buffer.getLemmas(list);
    }

    @Override
    public CharSequence getOriginal() {
        return this.buffer.getOriginal();
    }

    @Override
    public TokenIterator.TokenType getTokenType() {
        return this.buffer.getTokenType();
    }

    @Override
    public EnumSet<TokenIterator.TokenProperty> getTokenProperties() {
        return this.buffer.getTokenProperties();
    }

    @Override
    public boolean next() {
        if (this.buffer.next()) {
            return true;
        }
        this.buffer.reset();
        if (this.eoi) {
            return false;
        }
        boolean hasWildcard = false;
        if (this.lastOriginal != null) {
            this.buffer.append(this.lastOriginal, this.lastLemmas, this.lastType, this.lastProps, this.lastBegin, this.lastEnd);
            if (!(hasWildcard |= this.lastProps.contains((Object)TokenIterator.TokenProperty.HAS_WILDCARD)) && this.lastType == TokenIterator.TokenType.PUNCTUATION) {
                this.lastOriginal = null;
                return this.buffer.next();
            }
        }
        boolean hasgap = false;
        while (this.iterator.next()) {
            this.lastLemmas = this.iterator.getLemmas(new ArrayList<CharSequence>());
            this.lastType = this.iterator.getTokenType();
            this.lastProps = this.iterator.getTokenProperties();
            this.lastBegin = this.iterator.getBegin();
            this.lastEnd = this.iterator.getEnd();
            if (this.lastOriginal == null) {
                this.previousEnd = this.lastBegin;
            }
            this.lastOriginal = this.iterator.getOriginal();
            int gap = this.lastBegin - this.previousEnd;
            boolean separate = this.lastType == TokenIterator.TokenType.PUNCTUATION && !this.lastProps.contains((Object)TokenIterator.TokenProperty.HAS_WILDCARD);
            this.previousEnd = this.lastEnd;
            if ((gap > 0 || separate) && this.buffer.size() > 0) {
                hasgap = true;
                break;
            }
            hasWildcard |= this.lastProps.contains((Object)TokenIterator.TokenProperty.HAS_WILDCARD);
            this.buffer.append(this.lastOriginal, this.lastLemmas, this.lastType, this.lastProps, this.lastBegin, this.lastEnd);
            if (this.lastType != TokenIterator.TokenType.PUNCTUATION || this.lastProps.contains((Object)TokenIterator.TokenProperty.HAS_WILDCARD)) continue;
            hasgap = true;
            break;
        }
        if (hasWildcard) {
            StringBuilder orig = new StringBuilder();
            int begin = -1;
            int end = -1;
            while (this.buffer.next()) {
                if (begin < 0) {
                    begin = this.buffer.getBegin();
                }
                end = this.buffer.getEnd();
                orig.append(this.buffer.getOriginal());
            }
            this.buffer.reset();
            this.buffer.append(orig, null, TokenIterator.TokenType.REGULAR, EnumSet.of(TokenIterator.TokenProperty.HAS_WILDCARD), begin, end);
        }
        this.eoi = !hasgap;
        return this.buffer.next();
    }

    @Override
    public int getBegin() {
        return this.buffer.getBegin();
    }

    @Override
    public int getEnd() {
        return this.buffer.getEnd();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TokenGroup
    implements TokenIterator {
        private int rPos;
        private int wPos;
        private CharSequence[] originalList;
        private List<CharSequence>[] lemmaList;
        private TokenIterator.TokenType[] typeList;
        private EnumSet<TokenIterator.TokenProperty>[] propList;
        private int[] beginList;
        private int[] endList;

        private void reset() {
            this.rPos = -1;
            this.wPos = 0;
        }

        private TokenGroup(int capacity) {
            this.originalList = new CharSequence[capacity];
            this.lemmaList = new List[capacity];
            this.typeList = new TokenIterator.TokenType[capacity];
            this.propList = new EnumSet[capacity];
            this.beginList = new int[capacity];
            this.endList = new int[capacity];
            this.reset();
        }

        private void ensureCapacity(int min) {
            if (min > this.originalList.length) {
                int twice = this.originalList.length * 2;
                twice = min > twice ? min : twice;
                CharSequence[] tempO = new CharSequence[twice];
                List[] tempL = new List[twice];
                TokenIterator.TokenType[] tempT = new TokenIterator.TokenType[twice];
                EnumSet[] tempP = new EnumSet[twice];
                int[] tempB = new int[twice];
                int[] tempE = new int[twice];
                System.arraycopy(this.originalList, 0, tempO, 0, this.wPos);
                System.arraycopy(this.lemmaList, 0, tempL, 0, this.wPos);
                System.arraycopy(this.typeList, 0, tempT, 0, this.wPos);
                System.arraycopy(this.propList, 0, tempP, 0, this.wPos);
                System.arraycopy(this.beginList, 0, tempB, 0, this.wPos);
                System.arraycopy(this.endList, 0, tempE, 0, this.wPos);
                this.originalList = tempO;
                this.lemmaList = tempL;
                this.typeList = tempT;
                this.propList = tempP;
                this.beginList = tempB;
                this.endList = tempE;
            }
        }

        private void append(CharSequence o, List<CharSequence> l, TokenIterator.TokenType t, EnumSet<TokenIterator.TokenProperty> p, int b, int e) {
            this.ensureCapacity(this.wPos + 1);
            this.originalList[this.wPos] = o;
            this.lemmaList[this.wPos] = l;
            this.typeList[this.wPos] = t;
            this.propList[this.wPos] = p;
            this.beginList[this.wPos] = b;
            this.endList[this.wPos] = e;
            ++this.wPos;
        }

        private int size() {
            return this.wPos - this.rPos - 1;
        }

        @Override
        public CharSequence getLemma() {
            return this.lemmaList[this.rPos] != null && this.lemmaList[this.rPos].size() > 0 ? this.lemmaList[this.rPos].get(0) : null;
        }

        @Override
        public List<CharSequence> getLemmas(List<CharSequence> list) {
            list.clear();
            if (this.lemmaList[this.rPos] != null) {
                list.addAll(this.lemmaList[this.rPos]);
            }
            return list;
        }

        @Override
        public CharSequence getOriginal() {
            return this.originalList[this.rPos];
        }

        @Override
        public TokenIterator.TokenType getTokenType() {
            return this.typeList[this.rPos];
        }

        @Override
        public EnumSet<TokenIterator.TokenProperty> getTokenProperties() {
            return this.propList[this.rPos];
        }

        @Override
        public boolean next() {
            if (this.rPos + 1 < this.wPos) {
                ++this.rPos;
                return true;
            }
            return false;
        }

        @Override
        public int getBegin() {
            return this.beginList[this.rPos];
        }

        @Override
        public int getEnd() {
            return this.endList[this.rPos];
        }
    }
}

