/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer.uima;

import com.ibm.es.nuvo.tokenizer.uima.TokenIterator;
import java.util.EnumSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TokenIteratorAggregator
implements TokenIterator {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private TokenIterator[] iterators = new TokenIterator[2];
    private TokenIterator current;
    private int previousEnd;
    private TokenIterator stack;
    private WhitespaceIterator whitespace;

    TokenIteratorAggregator(TokenIterator it1, TokenIterator it2) {
        if (it1.next()) {
            this.iterators[0] = it1;
        }
        if (it2.next()) {
            this.iterators[1] = it2;
        }
        this.whitespace = new WhitespaceIterator();
    }

    @Override
    public boolean next() {
        if (this.stack != null) {
            this.current = this.stack;
            this.stack = null;
            this.previousEnd = this.current.getEnd();
            return true;
        }
        if (this.current != null && !this.current.next()) {
            if (this.iterators[0] == this.current) {
                this.iterators[0] = null;
            } else {
                this.iterators[1] = null;
            }
        }
        if (this.iterators[0] != null && this.iterators[1] != null) {
            int diff = this.iterators[1].getBegin() - this.iterators[0].getBegin();
            if (diff == 0) {
                diff = this.iterators[1].getEnd() - this.iterators[1].getEnd();
            }
            this.current = this.iterators[diff >= 0 ? 0 : 1];
        } else {
            this.current = this.iterators[0] != null ? this.iterators[0] : (this.iterators[1] != null ? this.iterators[1] : null);
        }
        if (this.current != null) {
            if (this.previousEnd < this.current.getBegin()) {
                this.whitespace.setLocation(this.previousEnd, this.current.getBegin());
                this.previousEnd = this.current.getEnd();
                this.stack = this.current;
                this.current = this.whitespace;
            } else {
                this.previousEnd = this.current.getEnd();
            }
        }
        return this.current != null;
    }

    @Override
    public int getBegin() {
        return this.current.getBegin();
    }

    @Override
    public int getEnd() {
        return this.current.getEnd();
    }

    @Override
    public TokenIterator.TokenType getTokenType() {
        return this.current.getTokenType();
    }

    @Override
    public CharSequence getOriginal() {
        return this.current.getOriginal();
    }

    @Override
    public CharSequence getLemma() {
        return this.current.getLemma();
    }

    @Override
    public List<CharSequence> getLemmas(List<CharSequence> list) {
        return this.current.getLemmas(list);
    }

    @Override
    public EnumSet<TokenIterator.TokenProperty> getTokenProperties() {
        return this.current.getTokenProperties();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WhitespaceIterator
    implements TokenIterator {
        private int begin;
        private int end;

        private WhitespaceIterator() {
        }

        @Override
        public CharSequence getLemma() {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        public List<CharSequence> getLemmas(List<CharSequence> list) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        public CharSequence getOriginal() {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        public EnumSet<TokenIterator.TokenProperty> getTokenProperties() {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        public TokenIterator.TokenType getTokenType() {
            return TokenIterator.TokenType.WHITESPACE;
        }

        @Override
        public int getBegin() {
            return this.begin;
        }

        @Override
        public int getEnd() {
            return this.end;
        }

        @Override
        public boolean next() {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public void setLocation(int begin, int end) {
            this.begin = begin;
            this.end = end;
        }
    }
}

