/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer.uima;

import com.ibm.es.nuvo.tokenizer.uima.AbstractTokenIterator;
import com.ibm.es.nuvo.tokenizer.uima.TokenIterator;
import com.ibm.uima.cas.Feature;
import com.ibm.uima.cas.Type;
import com.ibm.uima.cas.impl.LowLevelCAS;
import com.ibm.uima.cas.text.TCAS;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RegularTokenIterator
extends AbstractTokenIterator
implements TokenIterator {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private LowLevelCAS llCas;
    private int lemmaAtTokenFeatureCode;
    private int lemmaListAtTokenFeatureCode;
    private int lemmaListHeadFeatureCode;
    private int lemmaListTailFeatureCode;
    private int nonEmptyListTypeCode;
    private int lemmaKeyFeatureCode;
    private int tokenTypeFeatureCode;
    private boolean usePuncInsteadOfMath;
    private boolean usePuncInsteadOfCurrency;

    RegularTokenIterator(TCAS tcas, boolean runtimeMode, boolean usePuncForMathSymbol, boolean usePuncForCurrencySymbol) {
        super(tcas, "uima.tt.TokenAnnotation", runtimeMode);
        this.usePuncInsteadOfMath = usePuncForMathSymbol;
        this.usePuncInsteadOfCurrency = usePuncForCurrencySymbol;
        this.llCas = tcas.getLowLevelCAS();
        Feature lemmaAtTokenFeature = tcas.getTypeSystem().getFeatureByFullName("uima.tt.TokenAnnotation:lemma");
        Feature lemmaListAtTokenFeature = tcas.getTypeSystem().getFeatureByFullName("uima.tt.TokenAnnotation:lemmaEntries");
        Feature lemmaListHeadFeature = tcas.getTypeSystem().getFeatureByFullName("uima.cas.NonEmptyFSList:head");
        Feature lemmaListTailFeature = tcas.getTypeSystem().getFeatureByFullName("uima.cas.NonEmptyFSList:tail");
        Feature lemmaKeyFeature = tcas.getTypeSystem().getFeatureByFullName("uima.tt.KeyStringEntry:key");
        Type nonEmptyListType = tcas.getTypeSystem().getType("uima.cas.NonEmptyFSList");
        this.lemmaAtTokenFeatureCode = this.llCas.ll_getTypeSystem().ll_getCodeForFeature(lemmaAtTokenFeature);
        this.lemmaListAtTokenFeatureCode = this.llCas.ll_getTypeSystem().ll_getCodeForFeature(lemmaListAtTokenFeature);
        this.lemmaListHeadFeatureCode = this.llCas.ll_getTypeSystem().ll_getCodeForFeature(lemmaListHeadFeature);
        this.lemmaListTailFeatureCode = this.llCas.ll_getTypeSystem().ll_getCodeForFeature(lemmaListTailFeature);
        this.lemmaKeyFeatureCode = this.llCas.ll_getTypeSystem().ll_getCodeForFeature(lemmaKeyFeature);
        this.tokenTypeFeatureCode = this.llCas.ll_getTypeSystem().ll_getCodeForFeatureName("uima.tt.TokenLikeAnnotation:frost_TokenType");
        this.nonEmptyListTypeCode = this.llCas.ll_getTypeSystem().ll_getCodeForType(nonEmptyListType);
    }

    @Override
    public CharSequence getLemma() {
        int lemmaAtTokenAdr = this.llCas.ll_getRefValue(this.getAddress(), this.lemmaAtTokenFeatureCode);
        if (lemmaAtTokenAdr != 0) {
            return this.llCas.ll_getStringValue(lemmaAtTokenAdr, this.lemmaKeyFeatureCode);
        }
        return null;
    }

    @Override
    public List<CharSequence> getLemmas(List<CharSequence> list) {
        int lemmaListAdr = this.llCas.ll_getRefValue(this.getAddress(), this.lemmaListAtTokenFeatureCode);
        list.clear();
        if (lemmaListAdr == 0) {
            CharSequence lemma = this.getLemma();
            if (lemma != null) {
                list.add(lemma);
                return list;
            }
            return null;
        }
        while (this.llCas.ll_getFSRefType(lemmaListAdr) == this.nonEmptyListTypeCode) {
            int lemmaAdr = this.llCas.ll_getRefValue(lemmaListAdr, this.lemmaListHeadFeatureCode);
            if (lemmaAdr != 0) {
                String lemma = this.llCas.ll_getStringValue(lemmaAdr, this.lemmaKeyFeatureCode);
                boolean unique = true;
                for (int j = 0; j < list.size(); ++j) {
                    if (!list.get(j).equals(lemma)) continue;
                    unique = false;
                }
                if (unique) {
                    list.add(lemma);
                }
            }
            lemmaListAdr = this.llCas.ll_getRefValue(lemmaListAdr, this.lemmaListTailFeatureCode);
        }
        return list.size() == 0 ? null : list;
    }

    @Override
    public CharSequence getOriginal() {
        return this.subSequence();
    }

    @Override
    public TokenIterator.TokenType getTokenType() {
        int frostType = this.llCas.ll_getIntValue(this.getAddress(), this.tokenTypeFeatureCode);
        return 1 == frostType || this.usePuncInsteadOfMath && frostType == 600 || this.usePuncInsteadOfCurrency && frostType == 601 ? TokenIterator.TokenType.PUNCTUATION : TokenIterator.TokenType.REGULAR;
    }
}

