/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer.uima;

import com.ibm.es.nuvo.tokenizer.ResultHandler;
import com.ibm.es.nuvo.tokenizer.TToken;
import com.ibm.es.nuvo.tokenizer.uima.AbstractCASTokenizer;
import com.ibm.es.nuvo.tokenizer.uima.NgramTokenIterator;
import com.ibm.es.nuvo.tokenizer.uima.RegularTokenIterator;
import com.ibm.es.nuvo.tokenizer.uima.StopwordIterator;
import com.ibm.es.nuvo.tokenizer.uima.TokenIterator;
import com.ibm.es.nuvo.tokenizer.uima.TokenIteratorAggregator;
import com.ibm.es.nuvo.tokenizer.uima.WildcardTokenIterator;
import com.ibm.uima.cas.text.TCAS;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class CASRuntimeTokenizer
extends AbstractCASTokenizer {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private List<TToken> tokens = new ArrayList<TToken>();

    protected void extractAnnotations(TCAS tcas, ResultHandler handler) {
        RegularTokenIterator it1 = new RegularTokenIterator(tcas, true, this.usePuncForMathSymbol, this.usePuncForCurrencySymbol);
        NgramTokenIterator it2 = new NgramTokenIterator(tcas, true);
        TokenIteratorAggregator it = new TokenIteratorAggregator(new WildcardTokenIterator(it1), it2);
        StopwordIterator itStw = new StopwordIterator(tcas);
        if (!itStw.next()) {
            itStw = null;
        }
        int tokBegin = 0;
        int tokEnd = Integer.MAX_VALUE;
        while (it.next()) {
            tokBegin = it.getBegin();
            tokEnd = it.getEnd();
            if (itStw != null && itStw.getEnd() < tokBegin && !itStw.next()) {
                itStw = null;
            }
            switch (it.getTokenType()) {
                case WHITESPACE: 
                case PUNCTUATION: {
                    break;
                }
                case NGRAM: {
                    EnumSet<TokenIterator.TokenProperty> tProps = it.getTokenProperties();
                    TToken token = TToken.newToken(it.getOriginal(), TToken.Type.NGRAM);
                    if (tProps.contains((Object)TokenIterator.TokenProperty.HAS_WILDCARD)) {
                        token.addProperty(TToken.Property.HAS_WILDCARD);
                    }
                    handler.addToken(token, tokBegin, tokEnd);
                    break;
                }
                case REGULAR: {
                    EnumSet<TokenIterator.TokenProperty> tProps = it.getTokenProperties();
                    boolean isStopword = itStw != null && itStw.getBegin() <= tokBegin && itStw.getEnd() >= tokEnd;
                    boolean isAllUpper = tProps.contains((Object)TokenIterator.TokenProperty.ALL_UPPER);
                    boolean hasWildcard = tProps.contains((Object)TokenIterator.TokenProperty.HAS_WILDCARD);
                    this.generateRegularTokens(this.tokens, it, true);
                    for (int i = this.tokens.size() - 1; i >= 0; --i) {
                        TToken token1 = this.tokens.get(i);
                        if (isStopword) {
                            token1.addProperty(TToken.Property.STOPWORD);
                        }
                        if (isAllUpper) {
                            token1.addProperty(TToken.Property.ALL_UPPER);
                        }
                        if (hasWildcard) {
                            token1.addProperty(TToken.Property.HAS_WILDCARD);
                        }
                        handler.addToken(token1, tokBegin, tokEnd);
                    }
                    break;
                }
            }
        }
    }
}

