/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer.uima;

import com.ibm.es.nuvo.tokenizer.uima.AbstractCASIterator;
import com.ibm.es.nuvo.tokenizer.uima.TokenIterator;
import com.ibm.uima.cas.text.TCAS;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractTokenIterator
extends AbstractCASIterator
implements TokenIterator {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private EnumSet<TokenIterator.TokenProperty> tokenProps;
    private boolean runtimeMode;
    private static final int TOKEN_PROP_ALL_UPPER = 1;
    private static final int TOKEN_PROP_HAS_WILDCARD = 4;
    private static final char SINGLE_WILDCARD = '?';
    private static final char MULTI_WILDCARD = '*';

    AbstractTokenIterator(TCAS tcas, String type, boolean runtimeMode) {
        super(tcas, type);
        this.runtimeMode = runtimeMode;
    }

    @Override
    public boolean next() {
        this.tokenProps = null;
        return super.next();
    }

    @Override
    public EnumSet<TokenIterator.TokenProperty> getTokenProperties() {
        if (!this.runtimeMode) {
            throw new UnsupportedOperationException("This method cannot be called in indexer mode.");
        }
        if (this.tokenProps == null) {
            this.tokenProps = EnumSet.noneOf(TokenIterator.TokenProperty.class);
            CharSequence sequence = this.getOriginal();
            if (sequence != null && sequence.length() > 0) {
                int len = sequence.length();
                int prop = 1;
                for (int i = 0; i < len; ++i) {
                    char c = sequence.charAt(i);
                    if (Character.isUpperCase(c)) continue;
                    prop &= 0xFFFFFFFE;
                    if (c != '?' && c != '*') continue;
                    prop |= 4;
                    break;
                }
                if ((prop & 4) != 0) {
                    this.tokenProps.add(TokenIterator.TokenProperty.HAS_WILDCARD);
                } else if ((prop & 1) != 0) {
                    this.tokenProps.add(TokenIterator.TokenProperty.ALL_UPPER);
                }
            }
        }
        return this.tokenProps;
    }
}

