/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer.uima;

import com.ibm.es.nuvo.tokenizer.uima.CASIterator;
import com.ibm.uima.cas.impl.LowLevelCAS;
import com.ibm.uima.cas.impl.LowLevelIterator;
import com.ibm.uima.cas.text.TCAS;

abstract class AbstractCASIterator
implements CASIterator {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private LowLevelCAS llCas;
    private int beginFeatureCode;
    private int endFeatureCode;
    private LowLevelIterator it;
    protected int address;
    protected int begin;
    protected int end;
    private String documentBuffer;

    private AbstractCASIterator() {
    }

    protected AbstractCASIterator(TCAS tcas, String type) {
        this.llCas = tcas.getLowLevelCAS();
        this.beginFeatureCode = this.llCas.ll_getTypeSystem().ll_getCodeForFeatureName("uima.tcas.Annotation:begin");
        this.endFeatureCode = this.llCas.ll_getTypeSystem().ll_getCodeForFeatureName("uima.tcas.Annotation:end");
        int tokenTypeFeatureCode = this.llCas.ll_getTypeSystem().ll_getCodeForType(tcas.getTypeSystem().getType(type));
        this.it = this.llCas.ll_getIndexRepository().ll_getIndex("AnnotationIndex", tokenTypeFeatureCode).ll_iterator();
        this.documentBuffer = tcas.getDocumentText();
    }

    public boolean next() {
        if (this.it.isValid()) {
            this.address = this.it.ll_get();
            this.begin = this.llCas.ll_getIntValue(this.address, this.beginFeatureCode);
            this.end = this.llCas.ll_getIntValue(this.address, this.endFeatureCode);
            this.it.moveToNext();
            return true;
        }
        return false;
    }

    public int getBegin() {
        return this.begin;
    }

    public int getEnd() {
        return this.end;
    }

    protected final int getAddress() {
        return this.address;
    }

    protected final CharSequence subSequence() {
        return this.documentBuffer.subSequence(this.getBegin(), this.getEnd());
    }
}

