/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer.std;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.tokenizer.AbstractTokenizer;
import com.ibm.es.nuvo.tokenizer.ResultHandler;
import com.ibm.es.nuvo.tokenizer.TToken;
import com.ibm.es.nuvo.tokenizer.TokenizerException;
import com.ibm.es.nuvo.tokenizer.std.CharSequenceReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Properties;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.standard.StandardTokenizer;

public class StdTokenizer
extends AbstractTokenizer {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public void configure(Properties params) {
    }

    public void process(ResultHandler handler, CharSequence textToAnalyze, String knownLanguage, String defaultLanguage) throws TokenizerException {
        StandardTokenizer tokenizer = new StandardTokenizer((Reader)new CharSequenceReader(textToAnalyze));
        Token token = null;
        try {
            int location = 0;
            while ((token = tokenizer.next()) != null) {
                String term = token.termText();
                location += token.getPositionIncrement();
                handler.addToken(TToken.newToken(term, TToken.Type.ORIGINAL), token.startOffset(), token.endOffset());
            }
        }
        catch (IOException e) {
            throw new TokenizerException(new Message("P5999E.CANNOT_PROCESS_TEXT_STD"), (Throwable)e);
        }
    }
}

