/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer.service;

import com.ibm.es.nuvo.tokenizer.PoolableTokenizerFactory;
import com.ibm.es.nuvo.tokenizer.Tokenizer;
import com.ibm.es.nuvo.tokenizer.TokenizerConfig;
import com.ibm.es.nuvo.tokenizer.TokenizerConfigFactory;
import com.ibm.es.nuvo.tokenizer.TokenizerConfigMapper;
import com.ibm.es.nuvo.tokenizer.TokenizerException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public abstract class TokenizerRegistry
implements TokenizerConfigMapper,
PoolableTokenizerFactory {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private Map<String, TokenizerConfig> configMap = new HashMap<String, TokenizerConfig>();
    private TokenizerConfigFactory factory;

    TokenizerRegistry(TokenizerConfigFactory factory) {
        this.factory = factory;
    }

    synchronized void refresh(String cid) {
        this.configMap.put(cid, null);
    }

    protected abstract Tokenizer newTokenizer();

    public TokenizerConfig getConfig(String cid) throws TokenizerException {
        TokenizerConfig config = this.configMap.get(cid);
        if (config == null) {
            config = this.factory.createConfig(cid);
            this.configMap.put(cid, config);
        }
        return config;
    }

    public Tokenizer create(TokenizerConfig config) throws TokenizerException {
        Tokenizer tokenizer = this.newTokenizer();
        Properties params = new Properties();
        Iterator<TokenizerConfig.Parameter> ite = config.parameters();
        while (ite.hasNext()) {
            TokenizerConfig.Parameter param = ite.next();
            params.setProperty(param.getName(), param.getValue());
        }
        tokenizer.configure(params);
        return tokenizer;
    }

    public void destroy(Tokenizer tokenizer) throws TokenizerException {
    }
}

