/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer.service;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.tokenizer.Tokenizer;
import com.ibm.es.nuvo.tokenizer.TokenizerConfig;
import com.ibm.es.nuvo.tokenizer.TokenizerConfigFactory;
import com.ibm.es.nuvo.tokenizer.TokenizerException;
import com.ibm.es.nuvo.tokenizer.TokenizerPool;
import com.ibm.es.nuvo.tokenizer.service.DefaultTokenizerPoolFactory;
import com.ibm.es.nuvo.tokenizer.service.TokenizerRegistry;
import com.ibm.es.nuvo.tokenizer.uima.CASRuntimeTokenizer;
import com.ibm.es.nuvo.tokenizer.uima.CASTokenizer;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class TokenizerManager {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private TokenizerPool indexingPool;
    private TokenizerRegistry indexingRegistry = new TokenizerRegistry(new ConfigFactory("aggregate_indexing_default.xml", 125000)){

        protected Tokenizer newTokenizer() {
            return new CASTokenizer();
        }
    };
    private TokenizerPool runtimePool;
    private TokenizerRegistry runtimeRegistry;

    public TokenizerManager(int tokenizerPoolSize) {
        this.indexingPool = new DefaultTokenizerPoolFactory(this.indexingRegistry, this.indexingRegistry, tokenizerPoolSize, 0L).createPool();
        int runtimeTokenizerPoolSize = tokenizerPoolSize;
        this.runtimeRegistry = new TokenizerRegistry(new ConfigFactory("aggregate_runtime_default.xml", 2048)){

            protected Tokenizer newTokenizer() {
                return new CASRuntimeTokenizer();
            }
        };
        this.runtimePool = new DefaultTokenizerPoolFactory(this.runtimeRegistry, this.runtimeRegistry, runtimeTokenizerPoolSize, 0L).createPool();
    }

    public TokenizerManager() {
        this(GlobalConfiguration.getConfiguration().getNumberOfTokenizers());
    }

    public TokenizerPool getTokenizerPool() {
        return this.indexingPool;
    }

    public TokenizerPool getRuntimeTokenizerPool() {
        return this.runtimePool;
    }

    public void refreshCollection(String cid) {
        this.indexingRegistry.refresh(cid);
        this.runtimeRegistry.refresh(cid);
    }

    private static class ConfigFactory
    implements TokenizerConfigFactory {
        private String desc;
        private int initSize;

        ConfigFactory(String desc, int initSize) {
            this.desc = desc;
            this.initSize = initSize;
        }

        public TokenizerConfig createConfig(String cid) throws TokenizerException {
            CollectionConfiguration config;
            try {
                config = ConfigurationManager.getConfigurationManager().getCollection(cid);
            }
            catch (ConfigurationManagerException e) {
                Message msg = new Message("P5001E.NO_COLLECTION_CONFIG");
                msg.addArgument(cid);
                throw new TokenizerException(msg, (Throwable)e);
            }
            String uimaData = GlobalConfiguration.getConfiguration().getUimaDataPath() + File.separator;
            String indexDesc = uimaData + File.separator + this.desc;
            Properties tokProps = new Properties();
            tokProps.setProperty("whitney.tokenizer.uima.descriptor", indexDesc);
            tokProps.setProperty("whitney.tokenizer.uima.data", uimaData);
            tokProps.setProperty("whitney.tokenizer.uima.cas.initsize", String.valueOf(this.initSize));
            tokProps.setProperty("whitney.tokenizer.force_ngram", String.valueOf(config.isForceNgramForCJK()));
            tokProps.setProperty("whitney.tokenizer.all_lemmas", String.valueOf(config.isIndexAllLemmas()));
            tokProps.setProperty("whitney.tokenizer.collection.id", config.getId());
            return new TokenizerProperties(tokProps);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TokenizerProperties
    implements TokenizerConfig {
        private final Map<String, TokenizerConfig.Parameter> params = new HashMap<String, TokenizerConfig.Parameter>();

        TokenizerProperties(Properties props) {
            if (props != null) {
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    this.params.put(key, new TokenizerParameter(key, value));
                }
            }
        }

        @Override
        public Iterator<TokenizerConfig.Parameter> parameters() {
            return this.params.values().iterator();
        }

        @Override
        public TokenizerConfig.Parameter getParameter(String name) {
            return this.params.get(name);
        }

        public boolean equals(Object o) {
            if (o != null && o instanceof TokenizerProperties) {
                TokenizerProperties other = (TokenizerProperties)o;
                return ((Object)this.params).equals(other.params);
            }
            return false;
        }

        public int hashCode() {
            return ((Object)this.params).hashCode();
        }

        private static class TokenizerParameter
        implements TokenizerConfig.Parameter {
            private final String name;
            private final String value;

            private TokenizerParameter(String name, String value) {
                this.name = name;
                this.value = value;
            }

            public String getName() {
                return this.name;
            }

            public String getValue() {
                return this.value;
            }

            public boolean equals(Object o) {
                if (o != null && o instanceof TokenizerParameter) {
                    TokenizerParameter other = (TokenizerParameter)o;
                    return this.hashCode() == other.hashCode();
                }
                return false;
            }

            public int hashCode() {
                return (this.name != null ? this.name.hashCode() : 0) + (this.value != null ? this.value.hashCode() : 0);
            }

            public String toString() {
                return "[" + this.name + ":" + this.value + "]";
            }
        }
    }
}

