/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer.service;

import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.tokenizer.Tokenizer;
import com.ibm.es.nuvo.tokenizer.TokenizerConfig;
import com.ibm.es.nuvo.tokenizer.TokenizerConfigFactory;
import com.ibm.es.nuvo.tokenizer.TokenizerException;
import com.ibm.es.nuvo.tokenizer.service.DefaultTokenizerPool;
import com.ibm.es.nuvo.tokenizer.service.TokenizerManager;
import com.ibm.es.nuvo.tokenizer.service.TokenizerRegistry;
import com.ibm.es.nuvo.tokenizer.uima.CASRuntimeTokenizer;
import com.ibm.es.nuvo.tokenizer.uima.CASTokenizer;
import java.io.File;
import java.util.EnumSet;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticTokenizerPool
extends DefaultTokenizerPool {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String TEST_COL_ID = "test_col";

    public StaticTokenizerPool(Mode mode) {
        this(mode, null);
    }

    public StaticTokenizerPool(Mode mode, EnumSet<Option> options) {
        super(null, null, 1, 0L);
        TokenizerRegistry registry = null;
        String uimaData = GlobalConfiguration.getConfiguration().getUimaDataPath() + File.separator;
        String desc = null;
        String init = null;
        ConfigFactory factory = new ConfigFactory();
        switch (mode) {
            case MODE_INDEX: {
                desc = uimaData + File.separator + "aggregate_indexing_default.xml";
                init = "125000";
                registry = new TokenizerRegistry(factory){

                    protected Tokenizer newTokenizer() {
                        return new CASTokenizer();
                    }
                };
                break;
            }
            case MODE_QUERY: {
                desc = uimaData + File.separator + "aggregate_runtime_default.xml";
                init = "2048";
                registry = new TokenizerRegistry(factory){

                    protected Tokenizer newTokenizer() {
                        return new CASRuntimeTokenizer();
                    }
                };
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        Properties props = new Properties();
        props.setProperty("whitney.tokenizer.uima.descriptor", desc);
        props.setProperty("whitney.tokenizer.uima.data", uimaData);
        props.setProperty("whitney.tokenizer.uima.cas.initsize", init);
        if (options != null && options.contains((Object)Option.FORCE_NGRAM)) {
            props.setProperty("whitney.tokenizer.force_ngram", "true");
        }
        if (options != null && options.contains((Object)Option.INDEX_ALL_LEMMAS)) {
            props.setProperty("whitney.tokenizer.all_lemmas", "true");
        }
        factory.setProperties(new TokenizerManager.TokenizerProperties(props));
        super.setFactory(registry);
        super.setMapper(registry);
    }

    @Override
    public Tokenizer aquire(String cid) throws TokenizerException {
        return super.aquire(TEST_COL_ID);
    }

    private static class ConfigFactory
    implements TokenizerConfigFactory {
        private TokenizerManager.TokenizerProperties props;

        private ConfigFactory() {
        }

        void setProperties(TokenizerManager.TokenizerProperties props) {
            this.props = props;
        }

        public TokenizerConfig createConfig(String cid) throws TokenizerException {
            return this.props;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Option {
        FORCE_NGRAM,
        INDEX_ALL_LEMMAS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        MODE_INDEX,
        MODE_QUERY;

    }
}

