/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer.service;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.tokenizer.PoolableTokenizerFactory;
import com.ibm.es.nuvo.tokenizer.Tokenizer;
import com.ibm.es.nuvo.tokenizer.TokenizerConfig;
import com.ibm.es.nuvo.tokenizer.TokenizerConfigMapper;
import com.ibm.es.nuvo.tokenizer.TokenizerException;
import com.ibm.es.nuvo.tokenizer.TokenizerPool;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTokenizerPool
implements TokenizerPool {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private PoolableTokenizerFactory factory;
    private TokenizerConfigMapper mapper;
    private List<TokenizerConfig> cidList;
    private Map<Tokenizer, TokenizerConfig> borrowMap;
    private Map<TokenizerConfig, LinkedList<PooledTokenizer>> poolMap;
    private KeyedCounter activeCounter;
    private KeyedCounter idleCounter;
    private int maxPoolSize;
    private long maxWaitTime;
    private final Object lock = new Object();

    DefaultTokenizerPool(PoolableTokenizerFactory factory, TokenizerConfigMapper mapper) {
        this(factory, mapper, 1, 0L);
    }

    DefaultTokenizerPool(PoolableTokenizerFactory factory, TokenizerConfigMapper mapper, int maxPoolSize, long maxWaitTime) {
        this.factory = factory;
        this.mapper = mapper;
        this.cidList = new LinkedList<TokenizerConfig>();
        this.borrowMap = new HashMap<Tokenizer, TokenizerConfig>();
        this.poolMap = new HashMap<TokenizerConfig, LinkedList<PooledTokenizer>>();
        this.activeCounter = new KeyedCounter();
        this.idleCounter = new KeyedCounter();
        this.maxPoolSize = maxPoolSize;
        this.maxWaitTime = maxWaitTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedList<PooledTokenizer> getPooledTokenizerList(TokenizerConfig config) {
        Object object = this.lock;
        synchronized (object) {
            LinkedList<PooledTokenizer> pool = this.poolMap.get(config);
            if (pool == null) {
                pool = new LinkedList();
                this.poolMap.put(config, pool);
                this.cidList.add(config);
            }
            return pool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setFactory(PoolableTokenizerFactory factory) {
        Object object = this.lock;
        synchronized (object) {
            this.factory = factory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMapper(TokenizerConfigMapper mapper) {
        Object object = this.lock;
        synchronized (object) {
            this.mapper = mapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tokenizer aquire(String cid) throws TokenizerException {
        Object object = this.lock;
        synchronized (object) {
            PooledTokenizer pooledTok;
            TokenizerConfig config;
            block18: {
                config = this.mapper.getConfig(cid);
                if (config == null) {
                    Message msg = new Message("P5001E.NO_COLLECTION_CONFIG");
                    msg.addArgument(cid);
                    throw new TokenizerException(msg);
                }
                long start = System.currentTimeMillis();
                do {
                    pooledTok = null;
                    try {
                        pooledTok = this.getPooledTokenizerList(config).removeFirst();
                        if (pooledTok != null) {
                            this.idleCounter.decrement(config);
                        }
                    }
                    catch (NoSuchElementException ignore) {
                        // empty catch block
                    }
                    if (pooledTok != null) break block18;
                    int active = this.getNumberOfActive();
                    int idle = this.getNumberOfIdle();
                    if (this.maxPoolSize > 0 && idle > 0 && active + idle >= this.maxPoolSize) {
                        int size = this.cidList.size();
                        boolean removed = false;
                        for (int i = 0; i < size && !removed; ++i) {
                            LinkedList<PooledTokenizer> pool;
                            ListIterator tokenizers;
                            TokenizerConfig tmpcfg = this.cidList.get(i);
                            if (tmpcfg == config || !(tokenizers = (pool = this.getPooledTokenizerList(tmpcfg)).listIterator()).hasNext()) continue;
                            PooledTokenizer tokenizer = (PooledTokenizer)tokenizers.next();
                            try {
                                this.factory.destroy(tokenizer.tokenizer);
                            }
                            catch (Throwable ignore) {
                                // empty catch block
                            }
                            tokenizers.remove();
                            this.idleCounter.decrement(tmpcfg);
                            --idle;
                            removed = true;
                        }
                    }
                    if (this.maxPoolSize <= 0 || this.getNumberOfActive() + this.getNumberOfIdle() < this.maxPoolSize) {
                        pooledTok = new PooledTokenizer(this.factory.create(config));
                        break block18;
                    }
                    try {
                        if (this.maxWaitTime > 0L) {
                            this.lock.wait(this.maxWaitTime);
                            continue;
                        }
                        this.lock.wait();
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                } while (this.maxWaitTime <= 0L || System.currentTimeMillis() - start < this.maxWaitTime);
                Message msg = new Message("P5002E.CANNOT_AQUIRE_TOKENIZER_TIMEOUT");
                msg.addArgument(cid);
                throw new TokenizerException(msg);
            }
            this.activeCounter.increment(config);
            this.borrowMap.put(pooledTok.tokenizer, config);
            return pooledTok.tokenizer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(Tokenizer tokenizer) {
        Object object = this.lock;
        synchronized (object) {
            TokenizerConfig config = null;
            config = this.borrowMap.remove(tokenizer);
            if (config == null) {
                return;
            }
            this.getPooledTokenizerList(config).addFirst(new PooledTokenizer(tokenizer));
            this.activeCounter.decrement(config);
            this.idleCounter.increment(config);
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            int size = this.cidList.size();
            for (int i = 0; i < size; ++i) {
                TokenizerConfig config = this.cidList.get(i);
                LinkedList<PooledTokenizer> pool = this.getPooledTokenizerList(config);
                ListIterator tokenizers = pool.listIterator();
                while (tokenizers.hasNext()) {
                    PooledTokenizer tokenizer = (PooledTokenizer)tokenizers.next();
                    try {
                        this.factory.destroy(tokenizer.tokenizer);
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    tokenizers.remove();
                }
            }
            this.cidList.clear();
            this.poolMap.clear();
            this.idleCounter.clear();
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfActive() {
        Object object = this.lock;
        synchronized (object) {
            return this.activeCounter.total();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfActive(String cid) throws TokenizerException {
        Object object = this.lock;
        synchronized (object) {
            TokenizerConfig config = this.mapper.getConfig(cid);
            if (config == null) {
                return 0;
            }
            return this.activeCounter.count(config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfIdle() {
        Object object = this.lock;
        synchronized (object) {
            return this.idleCounter.total();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfIdle(String cid) throws TokenizerException {
        Object object = this.lock;
        synchronized (object) {
            TokenizerConfig config = this.mapper.getConfig(cid);
            if (config == null) {
                return 0;
            }
            return this.idleCounter.count(config);
        }
    }

    private static class PooledTokenizer {
        private Tokenizer tokenizer;

        private PooledTokenizer(Tokenizer tokenizer) {
            this.tokenizer = tokenizer;
        }
    }

    private static class KeyedCounter {
        private Map<TokenizerConfig, Integer> countMap;
        private int total;

        private KeyedCounter() {
            this.clear();
        }

        private void increment(TokenizerConfig key) {
            ++this.total;
            Integer count = this.countMap.get(key);
            this.countMap.put(key, count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1));
        }

        private void decrement(TokenizerConfig key) {
            --this.total;
            Integer count = this.countMap.get(key);
            if (count != null) {
                if (count < 2) {
                    this.countMap.remove(key);
                } else {
                    this.countMap.put(key, count - 1);
                }
            }
        }

        private int count(TokenizerConfig key) {
            Integer count = this.countMap.get(key);
            return count != null ? count : 0;
        }

        private int total() {
            return this.total;
        }

        private void clear() {
            this.total = 0;
            this.countMap = new HashMap<TokenizerConfig, Integer>();
        }
    }
}

