/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer.dlt;

import com.ibm.dltj.CapMatrix;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Session;
import com.ibm.dltj.parser.ParsingStream;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.tokenizer.AbstractTokenizer;
import com.ibm.es.nuvo.tokenizer.ResultHandler;
import com.ibm.es.nuvo.tokenizer.TokenizerException;
import com.ibm.es.nuvo.tokenizer.dlt.CharSequenceIterator;
import com.ibm.es.nuvo.tokenizer.dlt.FieldAggregatorHandler;
import java.text.CharacterIterator;
import java.util.Properties;

public class FrostTokenizer
extends AbstractTokenizer {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final String PARAM_DATA = "whitney.tokenizer.frost.data";
    public static final String PARAM_LOCALE = "whitney.tokenizer.frost.locale";
    public static final String PARAM_BREAKITERATOR = "whitney.tokenizer.frost.breakiterator";
    static CapMatrix capMatrix;
    private CapMatrix.Entry[] capMatrixEntries = null;
    private Dictionary[] dictionaries = null;
    private String locale;
    private String breakIteratorFile;
    private Session session;
    private FieldAggregatorHandler handler = new FieldAggregatorHandler();

    private static final void init(String frostData) throws DLTException {
        capMatrix = new CapMatrix(frostData);
    }

    public void configure(Properties params) throws TokenizerException {
        if (params == null) {
            throw new NullPointerException();
        }
        String frostData = params.getProperty(PARAM_DATA);
        this.locale = params.getProperty(PARAM_LOCALE);
        this.breakIteratorFile = params.getProperty(PARAM_BREAKITERATOR);
        try {
            FrostTokenizer.init(frostData);
            this.session = new Session(this.locale);
            if (this.breakIteratorFile != null) {
                this.session.setBreakIteratorByFilename(this.breakIteratorFile);
            }
            this.capMatrixEntries = capMatrix.getAvailableEntries(this.locale + "*", new int[]{15, -26, -56});
            if (this.capMatrixEntries.length == 0) {
                throw new DLTException("Dictionary for locale " + this.locale + " not found.");
            }
            this.dictionaries = new Dictionary[1];
            this.dictionaries[0] = this.capMatrixEntries[0].activate();
        }
        catch (DLTException e) {
            Message msg = new Message("P5997E.CANNOT_CREATE_FROST_TOKENIZER");
            msg.addArgument(this.locale);
            throw new TokenizerException(msg, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(ResultHandler resultHandler, CharSequence textToAnalyze, String knownLanguage, String defaultLanguage) throws TokenizerException {
        CharSequenceIterator iter = new CharSequenceIterator(textToAnalyze);
        this.handler.startDocument(resultHandler, textToAnalyze, iter);
        try {
            this.session.open(this.dictionaries, 0, 1, 0);
            try {
                this.session.processText((CharacterIterator)iter, (ParsingStream)this.handler);
            }
            finally {
                this.session.close();
            }
        }
        catch (DLTException e) {
            throw new TokenizerException(new Message("P5998E.CANNOT_PROCESS_TEXT_FROST"), (Throwable)e);
        }
    }
}

