/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer.dlt;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.gloss.LemmaGenerator;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.parser.ParsingStream;
import com.ibm.dltj.parser.RBBICategory;
import com.ibm.es.nuvo.tokenizer.ResultHandler;
import com.ibm.es.nuvo.tokenizer.TToken;
import java.text.CharacterIterator;

public class FieldAggregatorHandler
implements ParsingStream {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private ResultHandler aggregator;
    private int location = 0;
    private StringBuffer lemma = new StringBuffer();
    private CharSequence text = null;
    private CharacterIterator iter = null;

    void startDocument(ResultHandler handler, CharSequence textToAnalyze, CharacterIterator charIter) {
        this.aggregator = handler;
        this.text = textToAnalyze;
        this.iter = charIter;
        this.location = 0;
    }

    public void close() {
    }

    public void reset(UniLexAnalyzer analyzer) {
        this.location = 0;
    }

    public void createStd(int p, int begin, int end, GlossCollection gc) {
        MidGloss mid;
        LemmaGenerator lemmaGen;
        ++this.location;
        boolean hasLemma = false;
        Gloss gloss = gc.getGloss(MidGloss.class);
        if (gloss != null && (lemmaGen = (mid = (MidGloss)gloss).getLemmaGloss()) != null) {
            try {
                lemmaGen.getLemma(this.iter, begin, end, this.lemma);
                hasLemma = true;
            }
            catch (DLTException e) {
                // empty catch block
            }
        }
        if (hasLemma) {
            boolean lemmaEqualsOriginal;
            boolean bl = lemmaEqualsOriginal = this.lemma.length() == end - begin;
            if (lemmaEqualsOriginal) {
                for (int i = 0; i < this.lemma.length(); ++i) {
                    if (Character.toLowerCase(this.lemma.charAt(i)) == Character.toLowerCase(this.text.charAt(begin + i))) continue;
                    lemmaEqualsOriginal = false;
                    break;
                }
            }
            if (lemmaEqualsOriginal) {
                this.aggregator.addToken(TToken.newToken(this.text, begin, end, TToken.Type.BOTH), begin, end);
            } else {
                this.aggregator.addToken(TToken.newToken(this.text, begin, end, TToken.Type.ORIGINAL), begin, end);
                this.aggregator.addToken(TToken.newToken(this.lemma, 0, this.lemma.length(), TToken.Type.LEMMA), begin, end);
            }
        } else {
            this.aggregator.addToken(TToken.newToken(this.text, begin, end, TToken.Type.ORIGINAL), begin, end);
        }
    }

    public void createUnknown(int p, int begin, int end, int wclass) {
        if (wclass <= 10 && wclass > 0) {
            return;
        }
        if (RBBICategory.isWord((int)wclass)) {
            ++this.location;
            this.aggregator.addToken(TToken.newToken(this.text, begin, end, TToken.Type.ORIGINAL), begin, end);
            return;
        }
        switch (wclass) {
            case 1: 
            case 2: 
            case 3: 
            case 10: {
                return;
            }
        }
        ++this.location;
        this.aggregator.addToken(TToken.newToken(this.text, begin, end, TToken.Type.ORIGINAL), begin, end);
    }

    public void createBreakpoint(int arg0, int arg1, int arg2) {
    }

    public void createPunctuation(int p, int begin, int end, int flags) {
        ++this.location;
        this.aggregator.addToken(TToken.newToken(this.text, begin, end, TToken.Type.PUNCTUATION), begin, end);
    }

    public int startGroup(int arg0, int arg1, int arg2) {
        return 0;
    }

    public void closeGroup(int arg0) {
    }

    public void fork() {
    }

    public void addToFork() {
    }

    public void mergeRoutes(int arg0) {
    }
}

