/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer.annotators.ngram;

class RotatedCharBuffer {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private Buffer returned;
    private Buffer append;
    private Buffer[] incompleteBuffer;
    private int count;

    RotatedCharBuffer(int num) {
        int i;
        Buffer start;
        Buffer prev = start = new Buffer(num);
        for (i = 1; i < num; ++i) {
            Buffer b = new Buffer(num, prev, null);
            prev.setNext(b);
            prev = b;
        }
        start.setPrev(prev);
        prev.setNext(start);
        this.append = this.returned = start;
        this.incompleteBuffer = new Buffer[num - 1];
        for (i = 0; i < num - 1; ++i) {
            this.incompleteBuffer[i] = new Buffer(i + 1);
        }
    }

    public Buffer add(int location, int data) {
        ++this.count;
        Buffer b = this.append;
        for (int i = 0; i < this.count; ++i) {
            b.getBuffer()[i] = data;
            b = b.getPrev();
        }
        this.append.setLocation(location);
        Buffer ret = null;
        if (this.append.getNext() == this.returned) {
            ret = this.returned;
            this.returned = this.returned.getNext();
            --this.count;
        }
        this.append = this.append.getNext();
        return ret;
    }

    public Buffer get() {
        if (this.count == 0) {
            return null;
        }
        Buffer ret = this.incompleteBuffer[this.count - 1];
        System.arraycopy(this.returned.getBuffer(), 0, ret.getBuffer(), 0, this.count);
        ret.setLocation(this.returned.getLocation());
        this.returned = this.returned.getNext();
        --this.count;
        return ret;
    }

    public void reset() {
        this.count = 0;
        this.returned = this.append;
    }

    static class Buffer {
        private Buffer prev;
        private Buffer next;
        private int location;
        private int[] buf;

        Buffer(int size) {
            this.buf = new int[size];
        }

        Buffer(int size, Buffer prev, Buffer next) {
            this(size);
            this.prev = prev;
            this.next = next;
        }

        void setPrev(Buffer prev) {
            this.prev = prev;
        }

        void setNext(Buffer next) {
            this.next = next;
        }

        void setLocation(int location) {
            this.location = location;
        }

        int getLocation() {
            return this.location;
        }

        int[] getBuffer() {
            return this.buf;
        }

        Buffer getPrev() {
            return this.prev;
        }

        Buffer getNext() {
            return this.next;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.buf.length * 2 + 10);
            sb.append("[");
            for (int i = 0; i < this.buf.length; ++i) {
                sb.append(this.buf[i]).append(",");
            }
            sb.setLength(sb.length() - 1);
            sb.append("]@").append(this.location);
            return sb.toString();
        }
    }
}

