/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer.annotators.ngram;

import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NgramTokenizerConfig {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final int DEFAULT_GRAM = 2;
    public static final EnumSet<CharCategory> DEFAULT_NGRAM_CATEGORIES = EnumSet.of(CharCategory.NUMBER, CharCategory.OTHER);
    public static final EnumSet<CharCategory> DEFAULT_IGNORE_WHITESPACE_CATEGORIES = EnumSet.of(CharCategory.NUMBER, CharCategory.OTHER);
    public static final char DEFAULT_BOUNDARY_CHAR = ' ';
    public static final boolean DEFAULT_IGNORE_PUNCTUATION = false;
    public static final boolean DEFAULT_IGNORE_SENTENCE_BREAKERS = false;
    public static final RuntimeConfig DEFAULT_RUNTIME_CONFIG = null;
    public static final char DEFAULT_SINGLE_WILDCARD = '?';
    public static final char DEFAULT_MULTI_WILDCARD = '*';
    private int gram;
    private EnumSet<CharCategory> ngramCategories;
    private EnumSet<CharCategory> ignoreWhitespaceCategories;
    private boolean ignorePunctuation;
    private boolean ignoreSentenceBreakers;
    private char boundaryChar;
    private RuntimeConfig runtimeConfig;

    public NgramTokenizerConfig() {
        this(null);
    }

    public NgramTokenizerConfig(NgramTokenizerConfig defaultConfig) {
        if (defaultConfig != null) {
            this.gram = defaultConfig.getGram();
            this.ngramCategories = defaultConfig.getNgramCategories();
            this.ignoreWhitespaceCategories = defaultConfig.getIgnoreWhitespaceCategories();
            this.boundaryChar = defaultConfig.getBoundaryChar();
            this.ignorePunctuation = defaultConfig.isIgnorePunctuation();
            this.ignoreSentenceBreakers = defaultConfig.isIgnoreSentenceBreakers();
            this.runtimeConfig = defaultConfig.getRuntimeConfig();
        } else {
            this.gram = 2;
            this.ngramCategories = DEFAULT_NGRAM_CATEGORIES.clone();
            this.ignoreWhitespaceCategories = DEFAULT_IGNORE_WHITESPACE_CATEGORIES.clone();
            this.boundaryChar = (char)32;
            this.ignorePunctuation = false;
            this.ignoreSentenceBreakers = false;
            this.runtimeConfig = DEFAULT_RUNTIME_CONFIG;
        }
    }

    public char getBoundaryChar() {
        return this.boundaryChar;
    }

    public void setBoundaryChar(char boundaryChar) {
        this.boundaryChar = boundaryChar;
    }

    public int getGram() {
        return this.gram;
    }

    public void setGram(int gram) {
        this.gram = gram;
    }

    public RuntimeConfig getRuntimeConfig() {
        return this.runtimeConfig;
    }

    public EnumSet<CharCategory> getIgnoreWhitespaceCategories() {
        return this.ignoreWhitespaceCategories;
    }

    public void setIgnoreWhitespaceCategories(EnumSet<CharCategory> ignoreWhitespaceCategories) {
        this.ignoreWhitespaceCategories = ignoreWhitespaceCategories;
    }

    public EnumSet<CharCategory> getNgramCategories() {
        return this.ngramCategories;
    }

    public void setNgramCategories(EnumSet<CharCategory> ngramCategories) {
        this.ngramCategories = ngramCategories;
    }

    public void setRuntimeConfig(RuntimeConfig runtimeConfig) {
        this.runtimeConfig = runtimeConfig;
    }

    public boolean isIgnorePunctuation() {
        return this.ignorePunctuation;
    }

    public void setIgnorePunctuation(boolean ignorePunctuation) {
        this.ignorePunctuation = ignorePunctuation;
    }

    public boolean isIgnoreSentenceBreakers() {
        return this.ignoreSentenceBreakers;
    }

    public void setIgnoreSentenceBreakers(boolean ignoreSentenceBreakers) {
        this.ignoreSentenceBreakers = ignoreSentenceBreakers;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof NgramTokenizerConfig) {
            boolean ret;
            NgramTokenizerConfig other = (NgramTokenizerConfig)o;
            boolean bl = ret = this.gram == other.gram && this.ngramCategories.equals(other.ngramCategories) && this.ignoreWhitespaceCategories.equals(other.ignoreWhitespaceCategories) && this.boundaryChar == other.boundaryChar;
            if (ret) {
                ret = this.runtimeConfig == null ? other.runtimeConfig == null : this.runtimeConfig.equals(other.runtimeConfig);
            }
            return ret;
        }
        return false;
    }

    public int hashCode() {
        return Integer.valueOf(this.gram).hashCode() + this.ngramCategories.hashCode() + this.ignoreWhitespaceCategories.hashCode() + Character.valueOf(this.boundaryChar).hashCode() + (this.runtimeConfig != null ? this.runtimeConfig.hashCode() : 0);
    }

    public String toString() {
        return "Gram=" + this.gram + ", NgramCategories=" + this.ngramCategories + ", IgnoreWhitespaceCategories=" + this.ignoreWhitespaceCategories + ", BoundaryChar=" + this.boundaryChar + ", RuntimeConfig=" + this.runtimeConfig;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CharCategory {
        ALPHABET,
        NUMBER,
        OTHER;

    }

    public static class RuntimeConfig {
        private char[] wildcards = new char[2];

        public RuntimeConfig() {
            this.wildcards[0] = 63;
            this.wildcards[1] = 42;
        }

        public RuntimeConfig(char singleWildcard, char multiWildcard) {
            this.wildcards[0] = singleWildcard;
            this.wildcards[1] = multiWildcard;
        }

        public char getSingleWildcard() {
            return this.wildcards[0];
        }

        public char getMultiWildcard() {
            return this.wildcards[1];
        }

        public boolean equals(Object o) {
            if (o != null && o instanceof RuntimeConfig) {
                RuntimeConfig other = (RuntimeConfig)o;
                return this.wildcards[0] == other.wildcards[0] && this.wildcards[1] == other.wildcards[1];
            }
            return false;
        }

        public int hashCode() {
            return Character.valueOf(this.wildcards[0]).hashCode() + Character.valueOf(this.wildcards[1]).hashCode();
        }

        public String toString() {
            return "(" + this.wildcards[0] + "," + this.wildcards[1] + ")";
        }
    }
}

