/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer.annotators.ngram;

import com.ibm.es.nuvo.tokenizer.annotators.ngram.Dictionary;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryImpl
implements Dictionary {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private String entry;
    private Map<Character, DictionaryImpl> intermediate;
    private char[] index;
    private DictionaryImpl[] dictionaries;
    private char[] singleEntry;
    private boolean hasTerm = false;
    private char termAttr;
    private static final char TERM = '\uffff';
    private static final char ALPHA = '\u0001';
    private static final char NGRAM = '\u0002';
    private static final String NL = System.getProperty("line.separator");

    public static Dictionary load(Reader reader) throws IOException {
        String line;
        HashSet<String> terms = new HashSet<String>();
        BufferedReader br = new BufferedReader(reader);
        DictionaryImpl dict = new DictionaryImpl();
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) continue;
            char attr = '\u0000';
            if (line.startsWith("A|")) {
                attr = '\u0001';
            } else {
                if (!line.startsWith("N|")) continue;
                attr = '\u0002';
            }
            if ((line = line.substring(2).trim()).length() <= 0 || terms.contains(line)) continue;
            dict.add(line + '\uffff' + attr);
            terms.add(line);
        }
        if (terms.size() > 0) {
            dict.build();
            return dict;
        }
        return null;
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public int lookup(char[] term, int start, EnumSet<Dictionary.Flag> flags) {
        flags.clear();
        return this.lookupEntry(term, start, flags);
    }

    private DictionaryImpl() {
    }

    private void add(String newEntry) {
        if (this.intermediate == null && this.entry == null) {
            this.entry = newEntry;
        } else {
            if (this.intermediate == null) {
                this.intermediate = new TreeMap<Character, DictionaryImpl>();
                this.addSubEntry(this.entry);
                this.entry = null;
            }
            this.addSubEntry(newEntry);
        }
    }

    private void addSubEntry(String term) {
        char c = term.charAt(0);
        if (c != '\uffff') {
            DictionaryImpl child = this.intermediate.get(Character.valueOf(c));
            if (child == null) {
                child = new DictionaryImpl();
                this.intermediate.put(Character.valueOf(c), child);
            }
            child.add(term.substring(1));
        } else {
            this.hasTerm = true;
            this.termAttr = term.charAt(1);
        }
    }

    private void build() {
        if (this.entry != null) {
            this.singleEntry = this.entry.toCharArray();
        } else if (this.intermediate != null) {
            this.index = new char[this.intermediate.size()];
            this.dictionaries = new DictionaryImpl[this.intermediate.size()];
            int cnt = 0;
            for (Map.Entry<Character, DictionaryImpl> e : this.intermediate.entrySet()) {
                this.index[cnt] = e.getKey().charValue();
                this.dictionaries[cnt] = e.getValue();
                if (this.dictionaries[cnt] != null) {
                    this.dictionaries[cnt].build();
                }
                ++cnt;
            }
            this.intermediate = null;
        }
    }

    private int lookupEntry(char[] term, int start, EnumSet<Dictionary.Flag> flags) {
        if (this.singleEntry != null) {
            boolean ret;
            boolean bl = ret = term.length - start >= this.singleEntry.length - 2;
            if (ret) {
                for (int i = 0; i < this.singleEntry.length - 2; ++i) {
                    if (term[start + i] == this.singleEntry[i]) continue;
                    return -1;
                }
                this.setFlags(flags, this.singleEntry[this.singleEntry.length - 1]);
                return this.singleEntry.length - 2;
            }
        } else if (this.index != null) {
            if (start == term.length) {
                if (this.hasTerm) {
                    this.setFlags(flags, this.termAttr);
                    return 0;
                }
            } else {
                int location = Arrays.binarySearch(this.index, term[start]);
                if (location >= 0) {
                    int ret = this.dictionaries[location].lookup(term, start + 1, flags);
                    if (ret < 0) {
                        if (this.hasTerm) {
                            this.setFlags(flags, this.termAttr);
                            return 0;
                        }
                        return ret;
                    }
                    return ret + 1;
                }
            }
        }
        return -1;
    }

    private void setFlags(EnumSet<Dictionary.Flag> flags, char attr) {
        if ((attr & '\u0001') == 1) {
            flags.add(Dictionary.Flag.ALPHA);
        }
        if ((attr & 2) == 2) {
            flags.add(Dictionary.Flag.NGRAM);
        }
    }

    private String toString(String indent) {
        StringBuffer sb = new StringBuffer(256);
        if (this.singleEntry != null) {
            sb.append(indent);
            for (int i = 0; i < this.singleEntry.length - 2; ++i) {
                sb.append(this.singleEntry[i]);
            }
            char attr = this.singleEntry[this.singleEntry.length - 1];
            sb.append('$').append((int)attr).append(NL);
        } else if (this.index != null) {
            for (int i = 0; i < this.index.length; ++i) {
                sb.append(indent).append('(').append(this.index[i]).append(')').append(NL);
                DictionaryImpl dict = this.dictionaries[i];
                if (dict == null) continue;
                sb.append(this.dictionaries[i].toString(indent + "--"));
            }
            if (this.hasTerm) {
                sb.append(indent).append("$").append((int)this.termAttr).append(NL);
            }
        }
        return sb.toString();
    }
}

