/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer.annotators.ngram;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.lang.UScript;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CharClassifier {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final Type[] TYPE_MAPPING = new Type[]{Type.SYB, Type.UPR, Type.LWR, Type.UPR, Type.LTR, Type.LTR, Type.SYB, Type.SYB, Type.SYB, Type.NUM, Type.NUM, Type.NUM, Type.BLK, Type.NWL, Type.NPA, Type.BLK, Type.SYB, Type.LTR, Type.LTR, Type.PCT, Type.PCT, Type.PCT, Type.PCT, Type.PCT, Type.MSY, Type.CUR, Type.SYB, Type.SYB, Type.PCT, Type.PCT};
    static final Type[] FIXED_MAPPING = new Type[]{Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.NWL, Type.BLK, Type.BLK, Type.NWL, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.SND, Type.PCT, Type.PCT, Type.CUR, Type.PCT, Type.PCT, Type.PCT, Type.PCT, Type.PCT, Type.PCT, Type.MSY, Type.PCT, Type.PCT, Type.PRD, Type.PCT, Type.NUM, Type.NUM, Type.NUM, Type.NUM, Type.NUM, Type.NUM, Type.NUM, Type.NUM, Type.NUM, Type.NUM, Type.PCT, Type.PCT, Type.MSY, Type.MSY, Type.MSY, Type.SND, Type.PCT, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.PCT, Type.PCT, Type.PCT, Type.LTR, Type.LTR, Type.LTR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.PCT, Type.MSY, Type.PCT, Type.MSY, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.BLK, Type.SND, Type.CUR, Type.CUR, Type.CUR, Type.CUR, Type.SYB, Type.SYB, Type.SYB, Type.SYB, Type.LWR, Type.PCT, Type.MSY, Type.SYB, Type.SYB, Type.SYB, Type.SYB, Type.MSY, Type.NUM, Type.NUM, Type.SYB, Type.LWR, Type.SYB, Type.PCT, Type.SYB, Type.NUM, Type.LWR, Type.PCT, Type.NUM, Type.NUM, Type.NUM, Type.SND, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.MSY, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.UPR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.MSY, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR, Type.LWR};
    private static final int FIXED_MAP_SIZE = FIXED_MAPPING.length;
    private int singleWildcard = 65535;
    private int multiWildcard = 65535;
    private Map<Type, Attr> mappings;

    CharClassifier(EnumSet<Option> options) {
        int attr;
        EnumMap<Type, Attr> map = new EnumMap<Type, Attr>(Type.class);
        int n = attr = options.contains((Object)Option.NGRAM_OTHER) ? 2 : 1;
        if (!options.contains((Object)Option.IGNORE_SPACE_OTHER)) {
            attr |= 0x200;
        }
        Attr other = new Attr(attr);
        map.put(Type.INVALID, other);
        map.put(Type.BLK, new Attr(16));
        map.put(Type.SYB, other);
        map.put(Type.GRM, other);
        if (options.contains((Object)Option.IGNORE_SENTENCE_BREAKERS)) {
            map.put(Type.FST, other);
            map.put(Type.PRD, other);
            map.put(Type.SND, other);
        } else {
            map.put(Type.FST, new Attr(12));
            map.put(Type.PRD, new Attr(4));
            map.put(Type.SND, new Attr(4));
        }
        if (options.contains((Object)Option.IGNORE_PARAGRAPH)) {
            map.put(Type.NPA, other);
            map.put(Type.NWL, new Attr(16));
        } else {
            map.put(Type.NPA, new Attr(48));
            map.put(Type.NWL, new Attr(48));
        }
        attr = options.contains((Object)Option.NGRAM_NUMBER) ? 2 : 1;
        if (!options.contains((Object)Option.IGNORE_SPACE_NUMBER)) {
            attr |= 0x200;
        }
        map.put(Type.NUM, new Attr(attr));
        attr = options.contains((Object)Option.NGRAM_ALPHA) ? 2 : 1;
        if (!options.contains((Object)Option.IGNORE_SPACE_ALPHA)) {
            attr |= 0x200;
        }
        map.put(Type.LWR, new Attr(attr));
        map.put(Type.UPR, new Attr(attr));
        map.put(Type.LTR, new Attr(attr));
        if (options.contains((Object)Option.IGNORE_PUNCTUATION)) {
            map.put(Type.PCT, other);
            map.put(Type.MSY, other);
            map.put(Type.CUR, other);
        } else {
            attr = 65;
            if (!options.contains((Object)Option.IGNORE_SPACE_ALPHA)) {
                attr |= 0x200;
            }
            map.put(Type.CUR, new Attr(attr));
            map.put(Type.PCT, new Attr(attr));
            map.put(Type.MSY, new Attr(attr | 0x80));
        }
        this.mappings = map;
    }

    void setWildcard(int single, int multi) {
        this.singleWildcard = single;
        this.multiWildcard = multi;
    }

    static final Type getTypeFromRule(int c) {
        switch (c) {
            case 894: {
                return Type.SND;
            }
            case 1374: {
                return Type.SND;
            }
            case 1417: {
                return Type.FST;
            }
            case 8722: {
                return Type.MSY;
            }
            case 12290: {
                return Type.FST;
            }
            case 12539: {
                return Type.BLK;
            }
        }
        switch (UScript.getScript((int)c)) {
            case 2: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 38: 
            case 41: {
                return Type.GRM;
            }
        }
        if (UCharacter.getType((int)c) == 4) {
            int type = UCharacter.UnicodeBlock.of((int)c).getID();
            switch (type) {
                case 30: 
                case 62: 
                case 63: 
                case 65: 
                case 74: {
                    return Type.GRM;
                }
            }
        }
        return TYPE_MAPPING[UCharacter.getType((int)c)];
    }

    Attr getAttribute(int cp) {
        if (cp == this.singleWildcard || cp == this.multiWildcard) {
            return new Attr(256);
        }
        Type type = cp < FIXED_MAP_SIZE ? FIXED_MAPPING[cp] : CharClassifier.getTypeFromRule(cp);
        Attr attr = this.mappings.get((Object)type);
        if (attr != null) {
            return attr;
        }
        throw new UnsupportedOperationException("Unknown character type is found : " + (Object)((Object)type));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Attr {
        private static final int ALPHA = 1;
        private static final int NGRAM = 2;
        private static final int SENTENCE_END = 4;
        private static final int SENTENCE_END_FORCE = 12;
        private static final int WHITESPACE = 16;
        private static final int NEWLINE = 48;
        private static final int PUNCTUATION = 64;
        private static final int MATH_SYMBOL = 128;
        private static final int WILDCARD = 256;
        private static final int PRESERVE_WHITESPACE = 512;
        private int attr;
        private static Map<Integer, String> FLAGS;
        static Attr Alpha;
        static Attr Ngram;
        static Attr Whitespace;
        static Attr Newline;
        static Attr Punctuation;

        Attr() {
        }

        Attr(int attr) {
            this();
            this.attr = attr;
        }

        boolean isAlpha() {
            return (this.attr & 1) == 1;
        }

        boolean isNgram() {
            return (this.attr & 2) == 2;
        }

        boolean isSentenceEnd() {
            return (this.attr & 4) == 4;
        }

        boolean isSentenceEndForce() {
            return (this.attr & 0xC) == 12;
        }

        boolean isWhitespace() {
            return (this.attr & 0x10) == 16;
        }

        boolean isNewLine() {
            return (this.attr & 0x30) == 48;
        }

        boolean isWildcard() {
            return (this.attr & 0x100) == 256;
        }

        boolean isWhitespacePreserved() {
            return (this.attr & 0x200) == 512;
        }

        boolean isPunctuation() {
            return (this.attr & 0x40) == 64;
        }

        boolean isMathSymbol() {
            return (this.attr & 0x40) == 64;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            return o instanceof Attr ? this.attr == ((Attr)o).attr : false;
        }

        public int hashCode() {
            return Integer.valueOf(this.attr).hashCode();
        }

        public String toString() {
            StringBuffer sb = null;
            Map<Integer, String> flags = Attr.getFlags();
            for (Map.Entry<Integer, String> entry : flags.entrySet()) {
                int flag = entry.getKey();
                if ((this.attr & flag) != flag) continue;
                if (sb == null) {
                    sb = new StringBuffer();
                    sb.append("[");
                    sb.append(entry.getValue());
                    continue;
                }
                sb.append(",").append(entry.getValue());
            }
            if (sb != null) {
                return sb.append("]").toString();
            }
            return "[]";
        }

        private static synchronized Map<Integer, String> getFlags() {
            if (FLAGS == null) {
                HashMap<Integer, String> tmp = new HashMap<Integer, String>();
                tmp.put(1, "ALPHA");
                tmp.put(2, "NGRAM");
                tmp.put(4, "SENTENCE_END");
                tmp.put(12, "SENTENCE_END_FORCE");
                tmp.put(16, "WHITESPACE");
                tmp.put(48, "NEWLINE");
                tmp.put(256, "WILDCARD");
                tmp.put(512, "PRESERVE_WHITESPACE");
                FLAGS = tmp;
            }
            return FLAGS;
        }

        static {
            Alpha = new Attr(513);
            Ngram = new Attr(2);
            Whitespace = new Attr(16);
            Newline = new Attr(48);
            Punctuation = new Attr(65);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        INVALID,
        LWR,
        UPR,
        NUM,
        LTR,
        PRD,
        SND,
        BLK,
        NWL,
        PCT,
        MSY,
        SYB,
        NPA,
        CUR,
        FST,
        GRM,
        WLD;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Option {
        NGRAM_ALPHA,
        NGRAM_NUMBER,
        NGRAM_OTHER,
        IGNORE_SPACE_ALPHA,
        IGNORE_SPACE_NUMBER,
        IGNORE_SPACE_OTHER,
        IGNORE_PUNCTUATION,
        IGNORE_SENTENCE_BREAKERS,
        IGNORE_PARAGRAPH;

    }
}

