/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer.annotators.ngram;

import com.ibm.es.nuvo.tokenizer.annotators.ngram.CharClassifier;
import com.ibm.es.nuvo.tokenizer.annotators.ngram.Dictionary;
import java.util.EnumSet;
import java.util.LinkedList;

class CharArrayIterator {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static int INVALID_REPLACEMENT = 32;
    private int end;
    private CharClassifier cc;
    private Entry current;
    private Garbage garbage;
    private LinkedList<Entry> entries;
    private boolean preserveSpace;
    private CodePointIterator cpi;

    CharArrayIterator(CharClassifier cc) {
        this.cc = cc;
        this.cpi = new CodePointIterator();
    }

    void setArray(char[] doc, int start, int end, Dictionary dict) {
        CharClassifier.Attr attr;
        this.end = end;
        this.entries = new LinkedList();
        this.garbage = new Garbage();
        while (start < end && (attr = this.cc.getAttribute(doc[start])).isWhitespace()) {
            ++start;
        }
        this.cpi.setArray(doc, start, end, dict);
        this.accumulate();
    }

    boolean next() {
        block5: {
            if (this.current != null) {
                this.garbage.dispose(this.current);
            }
            while (true) {
                CharClassifier.Attr tmp;
                if (this.entries.size() == 0) {
                    this.accumulate();
                }
                if (this.entries.size() <= 0) break;
                this.current = this.entries.removeFirst();
                if (!(!this.current.getAttr().isWhitespace() || this.current.getAttr().isNewLine() || this.preserveSpace && (tmp = this.testNext(false)) != null && tmp.isWhitespacePreserved())) {
                    this.garbage.dispose(this.current);
                    continue;
                }
                break block5;
                break;
            }
            this.current = null;
        }
        if (this.current != null && (this.current.getAttr().isAlpha() || this.current.getAttr().isNgram())) {
            this.preserveSpace = this.current.getAttr().isWhitespacePreserved();
        }
        return this.current != null;
    }

    int getCodePoint() {
        return this.current != null ? this.current.getCodePoint() : 65535;
    }

    int getIndex() {
        return this.current != null ? this.current.getIndex() : this.end;
    }

    CharClassifier.Attr getAttr() {
        return this.current != null ? this.current.getAttr() : null;
    }

    CharClassifier.Attr testNext(boolean force) {
        for (int i = 0; i < this.entries.size(); ++i) {
            CharClassifier.Attr attr = this.entries.get(i).getAttr();
            if (!attr.isAlpha() && !attr.isNgram() && !force) continue;
            return attr;
        }
        block1: while (true) {
            int count = this.entries.size();
            this.accumulate();
            if (count == this.entries.size()) break;
            int i = count;
            while (true) {
                if (i >= this.entries.size()) continue block1;
                CharClassifier.Attr attr = this.entries.get(i).getAttr();
                if (attr.isAlpha() || attr.isNgram() || force) {
                    return attr;
                }
                ++i;
            }
            break;
        }
        return null;
    }

    int getNextIndex() {
        if (this.entries.size() == 0) {
            this.accumulate();
        }
        if (this.entries.size() > 0) {
            return this.entries.getFirst().getIndex();
        }
        return this.end;
    }

    private void accumulate() {
        if (this.cpi.next()) {
            int location = this.cpi.getIndex();
            int codePoint = this.cpi.getCodePoint();
            CharClassifier.Attr attr = location < this.cpi.getLookupEnd() ? (this.cpi.getLookupFlags().contains((Object)Dictionary.Flag.ALPHA) ? CharClassifier.Attr.Alpha : CharClassifier.Attr.Ngram) : this.cc.getAttribute(codePoint);
            if (attr.isWhitespace() || attr.isNewLine()) {
                int newline = 0;
                int prevCodePoint = codePoint;
                if (attr.isNewLine()) {
                    ++newline;
                }
                while (this.cpi.next()) {
                    attr = this.cpi.getIndex() < this.cpi.getLookupEnd() ? (this.cpi.getLookupFlags().contains((Object)Dictionary.Flag.ALPHA) ? CharClassifier.Attr.Alpha : CharClassifier.Attr.Ngram) : this.cc.getAttribute(this.cpi.getCodePoint());
                    if (attr.isNewLine() && (prevCodePoint != 13 || this.cpi.getCodePoint() != 10)) {
                        ++newline;
                    }
                    if (!attr.isWhitespace() && !attr.isNewLine()) break;
                    prevCodePoint = this.cpi.getCodePoint();
                }
                if (newline < 2) {
                    this.entries.addLast(this.getEntry(32, location, CharClassifier.Attr.Whitespace));
                } else {
                    this.entries.addLast(this.getEntry(10, location, CharClassifier.Attr.Newline));
                }
                if (this.cpi.getIndex() < this.end) {
                    this.entries.addLast(this.getEntry(this.cpi.getCodePoint(), this.cpi.getIndex(), attr));
                }
            } else {
                this.entries.addLast(this.getEntry(codePoint, location, attr));
            }
        }
    }

    private Entry getEntry(int codePoint, int index, CharClassifier.Attr attr) {
        Entry entry = this.garbage.recycle();
        if (entry == null) {
            entry = new Entry();
        }
        entry.setCodePoint(codePoint);
        entry.setIndex(index);
        entry.setAttr(attr);
        return entry;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("Current : ").append(this.current);
        for (Entry entry : this.entries) {
            sb.append(System.getProperty("line.separator")).append(" Next : ").append(entry);
        }
        sb.append(System.getProperty("line.separator")).append("(Entries in garbage : ").append(this.garbage.toString()).append(")");
        return sb.toString();
    }

    static class Garbage {
        private static final int CAPACITY = 5;
        private Entry[] list = new Entry[5];
        private int index;

        Garbage() {
        }

        public void dispose(Entry entry) {
            if (this.index + 1 < 5) {
                this.list[this.index++] = entry;
            }
        }

        public Entry recycle() {
            return this.index > 0 ? this.list[--this.index] : null;
        }

        public String toString() {
            return String.valueOf(this.index);
        }
    }

    private static class Entry {
        private int codePoint;
        private int index;
        private CharClassifier.Attr attr;

        Entry() {
        }

        CharClassifier.Attr getAttr() {
            return this.attr;
        }

        void setAttr(CharClassifier.Attr attr) {
            this.attr = attr;
        }

        int getIndex() {
            return this.index;
        }

        void setIndex(int index) {
            this.index = index;
        }

        int getCodePoint() {
            return this.codePoint;
        }

        void setCodePoint(int codePoint) {
            this.codePoint = codePoint;
        }

        public String toString() {
            return new String(Character.toChars(this.codePoint)) + "@" + this.index + " : " + this.attr;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CodePointIterator {
        private char[] doc;
        private int end;
        private int index;
        private int nextIndex;
        private int codePoint;
        private Dictionary dict;
        private int lookupEnd;
        private EnumSet<Dictionary.Flag> dictionaryFlags = EnumSet.noneOf(Dictionary.Flag.class);

        CodePointIterator() {
        }

        void setArray(char[] doc, int start, int end, Dictionary dict) {
            this.doc = doc;
            this.end = end;
            this.index = start - 1;
            this.nextIndex = start;
            this.codePoint = 65535;
            this.lookupEnd = -1;
            this.dict = dict;
        }

        boolean next() {
            if (this.nextIndex < this.end) {
                this.index = this.nextIndex;
                if (this.lookupEnd < this.nextIndex) {
                    int found = this.dict != null ? this.dict.lookup(this.doc, this.nextIndex, this.dictionaryFlags) : -1;
                    this.lookupEnd = found > 0 ? this.nextIndex + found : -1;
                }
                int cp = this.doc[this.nextIndex];
                if (Character.isHighSurrogate(this.doc[this.nextIndex])) {
                    if (this.nextIndex + 1 < this.end && Character.isLowSurrogate(this.doc[this.nextIndex + 1])) {
                        cp = Character.toCodePoint(this.doc[this.nextIndex], this.doc[this.nextIndex + 1]);
                        ++this.nextIndex;
                    } else {
                        cp = INVALID_REPLACEMENT;
                    }
                } else if (Character.isLowSurrogate(this.doc[this.nextIndex])) {
                    cp = INVALID_REPLACEMENT;
                }
                this.codePoint = cp;
                ++this.nextIndex;
                return true;
            }
            this.index = this.end;
            this.codePoint = 65535;
            return false;
        }

        int getCodePoint() {
            return this.codePoint;
        }

        int getIndex() {
            return this.index;
        }

        int getLookupEnd() {
            return this.lookupEnd;
        }

        EnumSet<Dictionary.Flag> getLookupFlags() {
            return this.dictionaryFlags;
        }
    }
}

