/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer.annotators;

import com.ibm.es.nuvo.tokenizer.annotators.AbstractTextAnnotator;
import com.ibm.uima.UIMAFramework;
import com.ibm.uima.analysis_engine.AnalysisEngineProcessException;
import com.ibm.uima.analysis_engine.ResultNotSupportedException;
import com.ibm.uima.analysis_engine.ResultSpecification;
import com.ibm.uima.analysis_engine.TextAnalysisEngine;
import com.ibm.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import com.ibm.uima.analysis_engine.annotator.AnnotatorContext;
import com.ibm.uima.analysis_engine.annotator.AnnotatorContextException;
import com.ibm.uima.analysis_engine.annotator.AnnotatorInitializationException;
import com.ibm.uima.analysis_engine.annotator.AnnotatorProcessException;
import com.ibm.uima.cas.CAS;
import com.ibm.uima.cas.FeatureStructure;
import com.ibm.uima.cas.TypeSystem;
import com.ibm.uima.cas.impl.LowLevelCAS;
import com.ibm.uima.cas.text.AnnotationFS;
import com.ibm.uima.cas.text.TCAS;
import com.ibm.uima.jFrostAnnotator.jFrostAnnotator;
import com.ibm.uima.resource.ResourceConfigurationException;
import com.ibm.uima.resource.ResourceManager;
import com.ibm.uima.resource.ResourceSpecifier;
import com.ibm.uima.util.XMLInputSource;

public class LanguageIDAnnotator
extends AbstractTextAnnotator {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private AnnotatorContext ctx = null;
    private int languageFeatureCode;
    private int fallbackLanguageFeatureCode;
    private boolean taeMode = false;
    private jFrostAnnotator langIDAnnot = null;
    private String langIdTaeDescriptor = null;
    private TextAnalysisEngine langIdTae = null;

    public void process(TCAS cas, ResultSpecification resultSpec) throws AnnotatorProcessException {
        this.determineLanguage(cas, resultSpec);
    }

    private void determineLanguage(TCAS cas, ResultSpecification resultSpec) throws AnnotatorProcessException {
        String existingLanguage = cas.getDocumentLanguage();
        if (existingLanguage != null && existingLanguage.length() > 0 && !existingLanguage.equals("x-unspecified")) {
            return;
        }
        if (this.taeMode) {
            try {
                this.langIdTae.process((CAS)cas, resultSpec);
            }
            catch (ResultNotSupportedException e) {
                throw new AnnotatorProcessException((Throwable)e);
            }
            catch (AnalysisEngineProcessException e) {
                throw new AnnotatorProcessException((Throwable)e);
            }
        } else {
            this.langIDAnnot.process(cas, resultSpec);
        }
        String computedLang = cas.getDocumentLanguage();
        if (computedLang == null || computedLang.equals("x-unspecified")) {
            AnnotationFS docFS;
            int addr;
            LowLevelCAS llcas = cas.getLowLevelCAS();
            String fallbackLanguage = llcas.ll_getStringValue(addr = llcas.ll_getFSRef((FeatureStructure)(docFS = cas.getDocumentAnnotation())), this.fallbackLanguageFeatureCode);
            if (fallbackLanguage == null || fallbackLanguage.length() == 0) {
                fallbackLanguage = "x-unspecified";
            }
            llcas.ll_setStringValue(addr, this.languageFeatureCode, fallbackLanguage);
        }
    }

    public void initialize(AnnotatorContext context) throws AnnotatorInitializationException, AnnotatorConfigurationException {
        this.ctx = context;
        this.readConfigurationSettings();
        if (this.langIdTaeDescriptor != null) {
            this.taeMode = true;
            try {
                ResourceManager mgr = UIMAFramework.newDefaultResourceManager();
                mgr.setDataPath(context.getDataPath());
                XMLInputSource in = new XMLInputSource(this.langIdTaeDescriptor);
                ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(in);
                this.langIdTae = UIMAFramework.produceTAE((ResourceSpecifier)specifier, (ResourceManager)mgr, null);
            }
            catch (Exception ex) {
                throw new AnnotatorConfigurationException((Throwable)ex);
            }
        } else {
            this.langIDAnnot = new jFrostAnnotator();
            this.langIDAnnot.initialize(context);
        }
    }

    public void typeSystemInit(TypeSystem ts) throws AnnotatorInitializationException, AnnotatorConfigurationException {
        this.languageFeatureCode = LanguageIDAnnotator.getFeatureCodeForName("uima.tcas.DocumentAnnotation:language", ts.getLowLevelTypeSystem());
        this.fallbackLanguageFeatureCode = LanguageIDAnnotator.getFeatureCodeForName("uima.tcas.DocumentAnnotation:fallbackLanguage", ts.getLowLevelTypeSystem());
        if (!this.taeMode) {
            this.langIDAnnot.typeSystemInit(ts);
        }
    }

    public void reconfigure() throws AnnotatorConfigurationException, AnnotatorInitializationException {
        if (this.taeMode) {
            try {
                this.langIdTae.reconfigure();
            }
            catch (ResourceConfigurationException e) {
                throw new AnnotatorConfigurationException((Throwable)e);
            }
        } else {
            this.langIDAnnot.reconfigure();
        }
        this.readConfigurationSettings();
    }

    public void destroy() {
        if (this.taeMode) {
            this.langIdTae.destroy();
        } else {
            this.langIDAnnot.destroy();
        }
    }

    private final void readConfigurationSettings() {
        if (this.ctx != null) {
            try {
                this.langIdTaeDescriptor = (String)this.ctx.getConfigParameterValue("langIdTaeDescriptor");
            }
            catch (AnnotatorContextException annotatorContextException) {
                // empty catch block
            }
        }
    }

    public static class Constants {
        public static final String UNSPECIFIED_LANGUAGE = "x-unspecified";
        public static final String FALLBACKLANGUAGE = "fallbackLanguage";
        public static final String LANGID_TAE_DESCRIPTOR = "langIdTaeDescriptor";
    }
}

