/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer.annotators;

import com.ibm.es.nuvo.tokenizer.annotators.AbstractTextAnnotator;
import com.ibm.uima.analysis_engine.ResultSpecification;
import com.ibm.uima.analysis_engine.TypeOrFeature;
import com.ibm.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import com.ibm.uima.analysis_engine.annotator.AnnotatorContext;
import com.ibm.uima.analysis_engine.annotator.AnnotatorInitializationException;
import com.ibm.uima.analysis_engine.annotator.AnnotatorProcessException;
import com.ibm.uima.cas.TypeSystem;
import com.ibm.uima.cas.impl.LowLevelCAS;
import com.ibm.uima.cas.impl.LowLevelIterator;
import com.ibm.uima.cas.text.TCAS;
import com.ibm.uima.jFrostAnnotator.jFrostAnnotator;

public class FrostWrapperAnnotator
extends AbstractTextAnnotator {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private int documentTypeCode;
    private int languageFeatureCode;
    private int useNgramForCJKFeatureCode;
    private int indexAllLemmasFeatureCode;
    private jFrostAnnotator wrappedAnnot = null;

    public void process(TCAS cas, ResultSpecification resultSpec) throws AnnotatorProcessException {
        int indexAllLemmas;
        LowLevelIterator llIter;
        int docAnAddr;
        LowLevelCAS llcas = cas.getLowLevelCAS();
        String existingLanguage = llcas.ll_getStringValue(docAnAddr = (llIter = llcas.ll_getIndexRepository().ll_getIndex("AnnotationIndex", this.documentTypeCode).ll_iterator()).ll_get(), this.languageFeatureCode);
        String twoLetterLanguage = existingLanguage.substring(0, 2).toLowerCase();
        if (twoLetterLanguage.equals("ja") || twoLetterLanguage.equals("zh") || twoLetterLanguage.equals("ko")) {
            int useNgramForCJK = llcas.ll_getIntValue(docAnAddr, this.useNgramForCJKFeatureCode);
            if (useNgramForCJK == 2) {
                return;
            }
            llcas.ll_setIntValue(docAnAddr, this.useNgramForCJKFeatureCode, 0);
        }
        if ((indexAllLemmas = llcas.ll_getIntValue(docAnAddr, this.indexAllLemmasFeatureCode)) != 1) {
            TypeOrFeature[] t;
            for (TypeOrFeature tf : t = resultSpec.getResultTypesAndFeatures("uima.tt.TokenAnnotation:lemmaEntries")) {
                if (!tf.getName().equals("uima.tt.TokenAnnotation:lemmaEntries")) continue;
                resultSpec.removeTypeOrFeature(tf);
            }
        }
        this.wrappedAnnot.process(cas, resultSpec);
    }

    public void initialize(AnnotatorContext ctx) throws AnnotatorInitializationException, AnnotatorConfigurationException {
        this.wrappedAnnot = new jFrostAnnotator();
        this.wrappedAnnot.initialize(ctx);
    }

    public void typeSystemInit(TypeSystem ts) throws AnnotatorInitializationException, AnnotatorConfigurationException {
        this.documentTypeCode = FrostWrapperAnnotator.getTypeCodeForName("uima.tcas.DocumentAnnotation", ts.getLowLevelTypeSystem());
        this.languageFeatureCode = FrostWrapperAnnotator.getFeatureCodeForName("uima.tcas.DocumentAnnotation:language", ts.getLowLevelTypeSystem());
        this.useNgramForCJKFeatureCode = FrostWrapperAnnotator.getFeatureCodeForName("uima.tcas.DocumentAnnotation:useNgramForCJK", ts.getLowLevelTypeSystem());
        this.indexAllLemmasFeatureCode = FrostWrapperAnnotator.getFeatureCodeForName("uima.tcas.DocumentAnnotation:indexAllLemmas", ts.getLowLevelTypeSystem());
        this.wrappedAnnot.typeSystemInit(ts);
    }

    public void reconfigure() throws AnnotatorConfigurationException, AnnotatorInitializationException {
        this.wrappedAnnot.reconfigure();
    }

    public void destroy() {
        this.wrappedAnnot.destroy();
    }
}

