/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer;

final class UTF16CharacterStream
implements CharSequence {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private byte[] text;
    private int begin;
    private int length;
    private StringBuilder buffer;

    UTF16CharacterStream() {
        this.length = 0;
        this.begin = 0;
    }

    private UTF16CharacterStream(byte[] text, int begin, int end) {
        this.reset(text, begin, end);
    }

    void reset(byte[] newText, int newBegin, int newEnd) {
        if (newText == null) {
            throw new NullPointerException();
        }
        if (newText.length < newEnd || newEnd < newBegin) {
            throw new IndexOutOfBoundsException();
        }
        this.text = newText;
        this.begin = newBegin;
        this.length = (newEnd - newBegin) / 2;
    }

    public int length() {
        return this.length;
    }

    public char charAt(int index) {
        int off = this.begin + index * 2;
        return (char)(this.text[off] << 8 | this.text[off + 1] & 0xFF);
    }

    public CharSequence subSequence(int start, int end) {
        return new UTF16CharacterStream(this.text, this.begin + start * 2, this.begin + end * 2);
    }

    public String toString() {
        if (this.length > 0) {
            int end = this.begin + this.length * 2;
            if (this.buffer == null) {
                this.buffer = new StringBuilder(this.length);
            } else {
                this.buffer.setLength(0);
            }
            int i = this.begin;
            while (i < end) {
                this.buffer.append((char)(this.text[i++] << 8 | this.text[i++] & 0xFF));
            }
            return this.buffer.toString();
        }
        return "";
    }
}

