/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer;

import com.ibm.es.nuvo.parser.XMLTagInfo;
import com.ibm.es.nuvo.parser.XMLTextBuffers;
import com.ibm.supa.tokenizers.TokenizationParams;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenizerProcessInput {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private String defaultLanguage;
    private String knownLanguage;
    private int startOfAttributeValues;
    private boolean indexSentenceAnnotations;
    private CharSequence text;
    private LinkedList<XMLTagInfo> xmlTagInfoList;
    private XMLTextBuffers xmlTextBuffers;
    private TokenizationParams tokenizationParams;
    private int endOfPlaintextPosition = Integer.MAX_VALUE;
    private boolean attributeValueSet = false;

    public TokenizerProcessInput() {
    }

    public TokenizerProcessInput(CharSequence textToBeTokenized, String knownLanguage, String defaultLanguage) {
        this.text = textToBeTokenized;
        this.knownLanguage = knownLanguage;
        this.defaultLanguage = defaultLanguage;
    }

    public void addXMLTagInfo(XMLTagInfo newTagInfo) {
        if (newTagInfo == null) {
            return;
        }
        XMLTextBuffers b = newTagInfo.getTextBuffers();
        if (b == null) {
            if (this.xmlTagInfoList == null) {
                this.xmlTagInfoList = new LinkedList();
            }
            this.xmlTagInfoList.add(newTagInfo);
        } else {
            this.xmlTextBuffers = b;
        }
    }

    public boolean indexSentenceAnnotations() {
        return this.indexSentenceAnnotations;
    }

    public int getStartOfAttributeValues() {
        return this.startOfAttributeValues;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public String getKnownLanguage() {
        return this.knownLanguage;
    }

    public CharSequence getText() {
        return this.text;
    }

    public XMLTextBuffers getXMLTextBuffers() {
        return this.xmlTextBuffers;
    }

    public Iterator<XMLTagInfo> getXMLTagInfo() {
        return this.xmlTagInfoList == null ? null : this.xmlTagInfoList.iterator();
    }

    public TokenizationParams getTokenizationParams() {
        return this.tokenizationParams;
    }

    public void setTokenizationParams(TokenizationParams tokenizationParams) {
        this.tokenizationParams = tokenizationParams;
    }

    public int getEndOfPlaintextPosition() {
        return this.endOfPlaintextPosition;
    }

    public void setEndOfPlaintextPosition(int endOfPlaintextPosition) {
        this.endOfPlaintextPosition = endOfPlaintextPosition;
    }

    public boolean isAttributeValueSet() {
        return this.attributeValueSet;
    }

    public void setAttributeValueSet(boolean attributeValueSet) {
        this.attributeValueSet = attributeValueSet;
    }

    public void setIndexSentenceAnnotations(boolean yesno) {
        this.indexSentenceAnnotations = yesno;
    }

    public void setDefaultLanguage(String newDefaultLanguage) {
        this.defaultLanguage = newDefaultLanguage;
    }

    public void setKnownLanguage(String newKnownLanguage) {
        this.knownLanguage = newKnownLanguage;
    }

    public void setStartOfAttributeValues(int newStart) {
        this.startOfAttributeValues = newStart;
    }

    public void setText(CharSequence newText) {
        this.text = newText;
    }
}

