/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.tokenizer.TokenVector;
import com.ibm.es.nuvo.tokenizer.TokenizerException;
import com.ibm.es.nuvo.util.Vint8;
import com.ibm.es.nuvo.util.stream.DocumentFieldInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.InflaterInputStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenizedDocument
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final int SUMMARIZER_FIELD_PREFIX_LENGTH = "_@".length();
    protected static final int TOKENS_VERSION_1 = 1;
    private Map<String, TokenVector> fieldMap;
    protected Document doc;

    protected TokenizedDocument(Document doc) {
        this(doc, new LinkedHashMap<String, TokenVector>());
    }

    protected TokenizedDocument(Document doc, Map<String, TokenVector> fieldMap) {
        this.doc = doc;
        this.fieldMap = fieldMap;
    }

    public TokenVector getField(String field) {
        return this.fieldMap.get(field);
    }

    public Set<String> getFieldNames() {
        return this.fieldMap.keySet();
    }

    public Document getDocument() {
        return this.doc;
    }

    protected Map<String, TokenVector> getFieldMap() {
        return this.fieldMap;
    }

    public static final TokenizedDocument readDocument(Document doc) throws IOException, TokenizerException {
        return TokenizedDocument.readDocument(doc, true);
    }

    public static final TokenizedDocument readDocument(Document doc, boolean required) throws IOException, TokenizerException {
        if (doc == null) {
            throw new IllegalArgumentException();
        }
        TokenizedDocument tokenizedDocument = new TokenizedDocument(doc);
        tokenizedDocument.loadTokenVectors(required);
        return tokenizedDocument;
    }

    protected void loadTokenVectors(boolean required) throws IOException, TokenizerException {
        if (this.doc.getField("_tokens") == null) {
            if (required) {
                throw new TokenizerException(new Message("P5003I.NO_TOKENS_FIELD"));
            }
            return;
        }
        InputStream in = new DocumentFieldInputStream(this.doc, "_tokens");
        in = new InflaterInputStream(in);
        StringBuffer buffer = new StringBuffer();
        int fieldLength = Vint8.decode(in);
        if (fieldLength > 0) {
            while (fieldLength > 0) {
                buffer.setLength(0);
                for (int i = 0; i < fieldLength; ++i) {
                    int hi = in.read();
                    int lo = in.read();
                    buffer.append((char)(hi << 8 | lo & 0xFF));
                }
                TokenVector tokenVector = new TokenVector();
                tokenVector.deserialize(in);
                String fieldName = buffer.toString();
                this.fieldMap.put(fieldName, tokenVector);
                fieldLength = Vint8.decode(in);
            }
        } else {
            int version;
            try {
                version = Vint8.decode(in);
            }
            catch (EOFException e) {
                version = 0;
            }
            switch (version) {
                case 0: {
                    break;
                }
                case 1: {
                    int count = Vint8.decode(in);
                    TokenVector[] vectors = new TokenVector[count];
                    for (int i = 0; i < count; ++i) {
                        vectors[i] = new TokenVector();
                        vectors[i].deserialize(in);
                    }
                    Vint8.Position pos = new Vint8.Position();
                    for (Object obj : this.doc.getFields()) {
                        Field f = (Field)obj;
                        String name = f.name();
                        if (!name.startsWith("_@")) continue;
                        name = name.substring(SUMMARIZER_FIELD_PREFIX_LENGTH);
                        pos.pos = 0;
                        int index = Vint8.decode(f.binaryValue(), pos);
                        this.fieldMap.put(name, vectors[index]);
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown _tokens version.");
                }
            }
        }
        in.close();
    }

    public void close() {
        for (TokenVector curTokenVector : this.fieldMap.values()) {
            if (curTokenVector == null) continue;
            curTokenVector.close();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (String name : this.fieldMap.keySet()) {
            TokenVector tokens = this.getField(name);
            sb.append("  <");
            sb.append(name);
            sb.append("> ");
            sb.append(tokens == null ? "null" : tokens.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.doc);
        out.writeInt(this.fieldMap.size());
        for (Map.Entry<String, TokenVector> entry : this.fieldMap.entrySet()) {
            out.writeUTF(entry.getKey());
            entry.getValue().serialize(out);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.doc = (Document)in.readObject();
        int len = in.readInt();
        this.fieldMap = new LinkedHashMap<String, TokenVector>();
        for (int i = 0; i < len; ++i) {
            String key = in.readUTF();
            TokenVector tv = new TokenVector();
            tv.deserialize(in);
            this.fieldMap.put(key, tv);
        }
    }
}

