/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.tokenizer;

import com.ibm.es.nuvo.normalizer.NormalizedStringBuffer;
import com.ibm.es.nuvo.normalizer.NormalizedStringBufferType2;
import com.ibm.es.nuvo.tokenizer.ReadableTToken;
import com.ibm.es.nuvo.tokenizer.TToken;
import com.ibm.es.nuvo.tokenizer.TokenVectorIterator;
import com.ibm.es.nuvo.tokenizer.UTF16CharacterStream;
import com.ibm.es.nuvo.util.Vint8;
import com.ibm.supa.config.AnalysisScopeConfig;
import com.ibm.supa.config.ConfigurationLoader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Payload;

public class TokenVector
extends TokenStream
implements Serializable {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final int MODE_CREATE = 0;
    public static final int MODE_INDEXER = 1;
    public static final int MODE_SUMMARY = 2;
    public static final int MODE_PRINT = 4;
    public static final int FLAG_NO_NORM = 1;
    public static final int FLAG_NOT_NORMALIZE = 2;
    private static final String EMPTY = "";
    private TokenVectorIterator.Mode mode = TokenVectorIterator.Mode.CREATE;
    private static final int BLOCK_SIZE = 4096;
    private static LinkedList<Block> freePool = new LinkedList();
    private static Object freeLock = new Object();
    private LinkedList<Block> blocks = new LinkedList();
    private transient Block currentBlock = null;
    private transient NormalizedStringBuffer normalizedBuffer = new NormalizedStringBufferType2();
    private int currentTokenTypePos;
    private transient TokenVectorIterator tokenIterator;
    private transient Header header;
    private ReadableTToken.TokenPositionIncrementer posIncrementer;
    private static final long serialVersionUID = 1L;

    public void setReadMode(int rm) {
        switch (rm) {
            case 2: {
                this.mode = TokenVectorIterator.Mode.SUMMARY;
                break;
            }
            case 1: {
                this.mode = TokenVectorIterator.Mode.INDEXER;
                break;
            }
            case 4: {
                this.mode = TokenVectorIterator.Mode.PRINT;
                break;
            }
            default: {
                this.mode = TokenVectorIterator.Mode.CREATE;
            }
        }
    }

    public byte[] getBytes() {
        if (this.blocks == null) {
            return new byte[0];
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ListIterator it = this.blocks.listIterator();
        while (it.hasNext()) {
            Block b = (Block)it.next();
            baos.write(b.bytes, 0, b.length);
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPool(int maxBlocks) {
        Object object = freeLock;
        synchronized (object) {
            for (int blocksInPool = freePool.size(); blocksInPool > maxBlocks; --blocksInPool) {
                freePool.removeFirst();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToPool(Block b) {
        Object object = freeLock;
        synchronized (object) {
            freePool.add(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Block getFromPool() {
        Block b;
        Object object = freeLock;
        synchronized (object) {
            if (freePool.isEmpty()) {
                return null;
            }
            b = freePool.removeFirst();
        }
        b.reset();
        return b;
    }

    private void freeBlocks() {
        while (!this.blocks.isEmpty()) {
            TokenVector.addToPool(this.blocks.removeFirst());
        }
        this.tokenIterator = null;
    }

    public void clear() {
        this.freeBlocks();
        this.tokenIterator = null;
        this.addBlock();
    }

    public boolean isEmpty() {
        return this.blocks.size() == 1 && this.currentBlock.length == 0;
    }

    public void begin() {
        this.tokenIterator = this.iterator(this.mode);
    }

    private void moveToEnd() {
        if (this.blocks == null) {
            this.addBlock();
        }
        this.currentBlock = this.blocks.getLast();
    }

    public Token next() {
        if (this.tokenIterator == null) {
            return null;
        }
        int previous = this.tokenIterator.getPosition();
        if (this.tokenIterator.next()) {
            String term = this.tokenIterator.toString();
            Token t = new Token(term, 0, term.length(), this.tokenIterator.getType().toString());
            int tpi = this.tokenIterator.getPositionIncrement();
            if (tpi < 0) {
                t.setPositionIncrement(this.tokenIterator.getPosition() - previous);
            } else {
                t.setPositionIncrement(tpi);
            }
            Payload p = this.tokenIterator.getLucenePayload();
            if (p != null) {
                t.setPayload(p);
            }
            return t;
        }
        return null;
    }

    public void close() {
        this.freeBlocks();
        this.tokenIterator = null;
    }

    public int skip(int n) {
        return this.tokenIterator.skip(n);
    }

    private void addBlock() {
        Block newBlock = TokenVector.getFromPool();
        if (newBlock == null) {
            newBlock = new Block();
        }
        if (this.blocks == null) {
            this.blocks = new LinkedList();
        }
        this.blocks.add(newBlock);
        this.currentBlock = newBlock;
    }

    public TokenVector() {
        this(null);
    }

    public TokenVector(Header h) {
        this(h, null);
    }

    public TokenVector(Header h, String collectionId) {
        this.header = h;
        if (collectionId == null) {
            this.posIncrementer = new DefaultPosIncrementer();
        } else {
            AnalysisScopeConfig config = ConfigurationLoader.getAnalysisScopeConfig(collectionId);
            this.posIncrementer = config.getTokenPositionIncrementer();
        }
        this.addBlock();
        if (h != null) {
            this.addToken(h.getHeaderToken());
        }
    }

    public int getMinPositionIncrement() {
        return this.posIncrementer.getMinPositionIncrement();
    }

    public int getSentencePositionIncrement() {
        return this.posIncrementer.getSentencePositionIncrement();
    }

    public int addToken(TToken token) {
        return this.addToken(token, true);
    }

    public int addToken(TToken token, boolean isContent) {
        int result = this.posIncrementer.getPositionIncrement(token);
        TToken.Type type = token.getType();
        if (type == TToken.Type.WHITESPACE) {
            byte[] byArray = this.currentBlock.bytes;
            int n = this.currentTokenTypePos;
            byArray[n] = (byte)(byArray[n] | 0x80);
            if (!isContent) {
                byte[] byArray2 = this.currentBlock.bytes;
                int n2 = this.currentTokenTypePos;
                byArray2[n2] = (byte)(byArray2[n2] | 0x40);
            }
            return result;
        }
        boolean normalize = type == TToken.Type.LEMMA;
        CharSequence term = token;
        if (normalize) {
            this.normalizedBuffer.setLength(0);
            this.normalizedBuffer.append(term);
            term = this.normalizedBuffer;
        }
        byte serializedType = (byte)(type.type & 0xF | (isContent ? 0 : 64));
        byte[] payload = token.getPayload();
        int termLength = term.length();
        int bytesForText = 2 * termLength;
        int bytesForTextLength = type != TToken.Type.HEADER ? Vint8.bytesNeeded(bytesForText) : 0;
        int bytesForPositionIncrement = type == TToken.Type.GENERIC || type == TToken.Type.HEADER ? Vint8.bytesNeeded(token.getPositionIncrement()) : 0;
        int bytesForPayload = payload != null ? Vint8.bytesNeeded(payload.length) + payload.length : 0;
        int bytesNeeded = 1 + bytesForPositionIncrement + bytesForPayload + bytesForTextLength + bytesForText;
        if (this.currentBlock.length + bytesNeeded > 4096) {
            if (bytesNeeded > 4096) {
                return result;
            }
            this.addBlock();
        }
        this.currentTokenTypePos = this.currentBlock.length;
        if (payload != null) {
            serializedType = (byte)(serializedType | 0x20);
        }
        ((Block)this.currentBlock).bytes[((Block)this.currentBlock).length] = serializedType;
        ++this.currentBlock.length;
        if (type == TToken.Type.GENERIC || type == TToken.Type.HEADER) {
            Vint8.encode(token.getPositionIncrement(), this.currentBlock.bytes, this.currentBlock.length);
            this.currentBlock.length += bytesForPositionIncrement;
        }
        if (payload != null) {
            this.currentBlock.length += Vint8.encode(payload.length, this.currentBlock.bytes, this.currentBlock.length);
            System.arraycopy(payload, 0, this.currentBlock.bytes, this.currentBlock.length, payload.length);
            this.currentBlock.length += payload.length;
        }
        if (type != TToken.Type.HEADER) {
            Vint8.encode(bytesForText, this.currentBlock.bytes, this.currentBlock.length);
            this.currentBlock.length += bytesForTextLength;
            for (int i = 0; i < termLength; ++i) {
                byte hi;
                char c = term.charAt(i);
                byte lo = (byte)(c & 0xFF);
                ((Block)this.currentBlock).bytes[((Block)this.currentBlock).length + 2 * i] = hi = (byte)(c >> 8);
                ((Block)this.currentBlock).bytes[((Block)this.currentBlock).length + 2 * i + 1] = lo;
            }
            this.currentBlock.length += bytesForText;
        }
        return result;
    }

    public void serialize(OutputStream out) throws IOException {
        for (Block block : this.blocks) {
            if (block.length <= 0) continue;
            Vint8.encode(block.length, out);
            out.write(block.bytes, 0, block.length);
        }
        Vint8.encode(0, out);
    }

    public void deserialize(InputStream in) throws IOException {
        Payload p;
        TokenIterator ti;
        int length;
        while ((length = Vint8.decode(in)) != 0) {
            int actual;
            if (this.currentBlock == null || this.currentBlock.remain() < length) {
                this.addBlock();
            }
            int remain = length;
            int off = 0;
            while (remain > 0 && (actual = in.read(this.currentBlock.bytes, off, remain)) != -1) {
                remain -= actual;
                off += actual;
            }
            if (remain != 0) {
                throw new IOException("truncated serialized form.");
            }
            this.currentBlock.length = length - remain;
        }
        if (this.blocks != null && this.blocks.size() > 0 && (ti = new TokenIterator(this.blocks)).next() && TToken.Type.HEADER == ti.getType() && (p = ti.getPayload()) != null) {
            this.header = new Header(ti.getPositionIncrement(), p.toByteArray());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.serialize(out);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.deserialize(in);
    }

    public void appendTokenVector(TokenVector tv) {
        BlockIterator other = new BlockIterator(tv.blocks);
        Block b = other.nextBlock();
        this.moveToEnd();
        int copyStart = -1;
        int tokenStart = -1;
        int nextTokenStart = -1;
        Vint8.Position position = new Vint8.Position();
        while (b != null) {
            if (position.pos >= b.length) {
                this.appendByteRangeFromOther(b, copyStart, nextTokenStart);
                copyStart = -1;
                tokenStart = -1;
                nextTokenStart = -1;
                b = other.nextBlock();
                if (b == null) break;
                position.pos = 0;
            }
            ++position.pos;
            if (copyStart < 0) {
                copyStart = tokenStart;
            }
            int textLength = Vint8.decode(b.bytes, position);
            nextTokenStart = position.pos + textLength;
            if (this.currentBlock.length + (nextTokenStart - copyStart) <= 4096) {
                position.pos = nextTokenStart;
                continue;
            }
            this.appendByteRangeFromOther(b, copyStart, tokenStart);
            copyStart = tokenStart;
            position.pos = nextTokenStart;
            this.addBlock();
        }
    }

    private void appendByteRangeFromOther(Block other, int start, int end) {
        int j = start;
        while (j < end) {
            ((Block)this.currentBlock).bytes[((Block)this.currentBlock).length++] = other.bytes[j++];
        }
    }

    public String toString() {
        return (this.header != null ? this.header.toString() : EMPTY) + this.toString(4);
    }

    public String toString(int rm) {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        int pos = 0;
        this.setReadMode(rm);
        this.begin();
        Token token = this.next();
        while (token != null) {
            pos += token.getPositionIncrement();
            if (!first) {
                buf.append(' ');
            } else {
                first = false;
            }
            buf.append(token.termText());
            buf.append('@');
            buf.append(pos);
            buf.append('[');
            buf.append(token.type());
            Payload p = token.getPayload();
            if (p != null) {
                int lim = p.length();
                for (int j = 0; j < lim; ++j) {
                    buf.append(p.byteAt(j));
                    if (j >= lim - 1) continue;
                    buf.append(',');
                }
            }
            buf.append(']');
            token = this.next();
        }
        return buf.toString();
    }

    public boolean equals(Object other) {
        TokenVector otherTV = null;
        if (!(other instanceof TokenVector)) {
            return false;
        }
        otherTV = (TokenVector)other;
        if (this.blocks == null ^ otherTV.blocks == null) {
            return false;
        }
        if (this.blocks == null) {
            return true;
        }
        if (this.blocks.size() != otherTV.blocks.size()) {
            return false;
        }
        ListIterator it1 = this.blocks.listIterator();
        ListIterator it2 = otherTV.blocks.listIterator();
        while (it1.hasNext() && it2.hasNext()) {
            Block b1 = (Block)it1.next();
            Block b2 = (Block)it2.next();
            if (b1.length != b2.length) {
                return false;
            }
            for (int j = 0; j < b1.length; ++j) {
                if (b1.bytes[j] == b2.bytes[j]) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public TokenVectorIterator iterator(TokenVectorIterator.Mode rm) {
        int flags = this.header != null ? this.header.getFlags() : 0;
        return new DefaultTokenVectorIterator(rm, new TokenIterator(this.blocks), flags);
    }

    public Header getHeader() {
        return this.header;
    }

    public static class Header {
        private static final int VERSION_1 = 1;
        private static final int CURRENT_VERSION = 1;
        private int flags;

        public Header(int flags) {
            this.flags = flags;
        }

        private Header(int version, byte[] data) {
            this.loadHeader(version, data);
        }

        public int getFlags() {
            return this.flags;
        }

        private TToken getHeaderToken() {
            byte[] data = new byte[Vint8.bytesNeeded(this.flags)];
            Vint8.encode(this.flags, data, 0);
            return TToken.newHeaderToken(1, data);
        }

        private void loadHeader(int version, byte[] bytes) {
            if (version != 1) {
                throw new UnsupportedOperationException("Unsupported token vector version : " + version);
            }
            Vint8.Position pos = new Vint8.Position();
            this.flags = Vint8.decode(bytes, pos);
        }

        public String toString() {
            ArrayList<String> tmp = new ArrayList<String>();
            if ((this.flags & 1) != 0) {
                tmp.add("NO_NORM");
            }
            if ((this.flags & 2) != 0) {
                tmp.add("NOT_NORMALIZE");
            }
            return "[Header (Flags:" + tmp + ")]";
        }
    }

    private class DefaultTokenVectorIterator
    implements TokenVectorIterator {
        private static final int BUFFER_SIZE = 32;
        private final TokenVectorIterator.Mode readMode;
        private int location;
        private StringBuilder buffer;
        private NormalizedStringBuffer normalized;
        private boolean generateLemma;
        private boolean generateWhitespace;
        private boolean isMetadata;
        private TToken.Type currentTokenType;
        private CharSequence currentTokenText;
        private Payload payload;
        private TokenIterator iterator;
        private boolean disableNormalize;

        private DefaultTokenVectorIterator(TokenVectorIterator.Mode mode, TokenIterator iterator, int flags) {
            this.readMode = mode;
            this.location = 0;
            this.generateLemma = false;
            this.generateWhitespace = false;
            this.isMetadata = false;
            this.currentTokenType = null;
            this.currentTokenText = TokenVector.EMPTY;
            this.buffer = new StringBuilder(32);
            this.normalized = new NormalizedStringBufferType2(32);
            this.iterator = iterator;
            this.disableNormalize = (flags & 2) != 0;
        }

        public final boolean next() {
            boolean needNormalization;
            if (this.generateLemma) {
                this.payload = null;
                if (this.currentTokenText != this.normalized) {
                    this.normalized.setLength(0);
                    this.normalized.append(this.currentTokenText);
                    this.currentTokenText = this.normalized;
                }
                this.generateLemma = false;
                this.normalized.append('\u0001');
                this.currentTokenType = TToken.Type.LEMMA;
                return true;
            }
            block4: while (true) {
                this.payload = null;
                if (this.generateWhitespace) {
                    this.generateWhitespace = false;
                    this.currentTokenText = TokenVector.EMPTY;
                    this.currentTokenType = TToken.Type.WHITESPACE;
                    return true;
                }
                if (!this.moveToNextToken()) {
                    return false;
                }
                needNormalization = false;
                this.generateLemma = false;
                switch (this.readMode) {
                    case INDEXER: {
                        if (TToken.Type.PUNCTUATION == this.currentTokenType || TToken.Type.SENTENCE == this.currentTokenType) continue block4;
                        needNormalization = TToken.Type.BOTH == this.currentTokenType || TToken.Type.ORIGINAL == this.currentTokenType || TToken.Type.NGRAM == this.currentTokenType;
                        this.generateLemma = TToken.Type.BOTH == this.currentTokenType;
                        break;
                    }
                    case SUMMARY: {
                        if (this.isMetadata && this.readMode == TokenVectorIterator.Mode.SUMMARY) {
                            this.generateWhitespace = false;
                            continue block4;
                        }
                        if (TToken.Type.LEMMA != this.currentTokenType) break;
                        continue block4;
                    }
                }
                if (TToken.Type.WHITESPACE != this.currentTokenType && TToken.Type.HEADER != this.currentTokenType) break;
            }
            if (needNormalization && !this.disableNormalize) {
                this.normalized.setLength(0);
                this.normalized.append(this.iterator.getText());
                this.currentTokenText = this.normalized;
            } else if (TToken.Type.LEMMA == this.currentTokenType) {
                this.buffer.setLength(0);
                this.buffer.append(this.iterator.getText());
                this.buffer.append('\u0001');
                this.currentTokenText = this.buffer;
            } else {
                this.currentTokenText = this.iterator.getText();
            }
            this.payload = this.iterator.getPayload();
            return true;
        }

        public final char charAt(int index) {
            return this.currentTokenText.charAt(index);
        }

        public final Payload getLucenePayload() {
            return this.payload;
        }

        public final TToken.Type getType() {
            return this.currentTokenType;
        }

        public final int length() {
            return this.currentTokenText.length();
        }

        public final int getPosition() {
            return this.location;
        }

        public final int getPositionIncrement() {
            return this.iterator.getPositionIncrement();
        }

        public final int skip(int n) {
            int startLocation = this.location;
            while (this.location < startLocation + n && this.moveToNextToken()) {
            }
            return this.location - startLocation;
        }

        public final String toString() {
            return ((Object)this.currentTokenText).toString();
        }

        private boolean moveToNextToken() {
            if (!this.iterator.next()) {
                return false;
            }
            this.currentTokenType = this.iterator.getType();
            int attr = this.iterator.getAttribute();
            if (!this.generateWhitespace) {
                this.generateWhitespace = TToken.Type.WHITESPACE.hasAttribute(attr) && this.readMode == TokenVectorIterator.Mode.SUMMARY;
            }
            boolean bl = this.isMetadata = (attr & 0x40) == 64;
            if (this.generateWhitespace && !this.iterator.hasMoreTokens()) {
                this.generateWhitespace = false;
            }
            this.location += TokenVector.this.posIncrementer.getPositionIncrement(this);
            return true;
        }

        public final CharSequence subSequence(int start, int end) {
            return this.currentTokenText.subSequence(start, end);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TokenIterator
    extends BlockIterator {
        private Vint8.Position position;
        private byte[] bytes = null;
        private int length = 0;
        private UTF16CharacterStream text = new UTF16CharacterStream();
        private Payload payload;
        private TToken.Type type;
        private int attr;
        private int positionIncrement;

        TokenIterator(List<Block> blocks) {
            super(blocks);
            this.position = new Vint8.Position();
        }

        Payload getPayload() {
            return this.payload;
        }

        public CharSequence getText() {
            return this.text;
        }

        int getAttribute() {
            return this.attr;
        }

        boolean hasMoreTokens() {
            return this.position.pos < this.length || this.hasMoreBlocks();
        }

        public String toString() {
            return this.text.toString();
        }

        TToken.Type getType() {
            return this.type;
        }

        int getPositionIncrement() {
            return this.positionIncrement;
        }

        boolean next() {
            if (this.position.pos >= this.length) {
                Block block = this.nextBlock();
                if (block == null) {
                    return false;
                }
                this.bytes = block.bytes;
                this.length = block.length;
                this.position.pos = 0;
            }
            int tokenType = this.bytes[this.position.pos] & 0xFF;
            ++this.position.pos;
            this.type = TToken.Type.getType(tokenType);
            this.attr = tokenType & 0xF0;
            this.positionIncrement = this.getType() == TToken.Type.GENERIC || this.getType() == TToken.Type.HEADER ? Vint8.decode(this.bytes, this.position) : -1;
            if ((this.attr & 0x20) != 0) {
                int serializedPayloadLength = Vint8.decode(this.bytes, this.position);
                this.payload = new Payload(this.bytes, this.position.pos, serializedPayloadLength);
                this.position.pos += serializedPayloadLength;
            } else {
                this.payload = null;
            }
            if (this.getType() != TToken.Type.HEADER) {
                int tokenTermLengthInUTF16 = Vint8.decode(this.bytes, this.position);
                this.text.reset(this.bytes, this.position.pos, this.position.pos + tokenTermLengthInUTF16);
                this.position.pos += tokenTermLengthInUTF16;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BlockIterator {
        private Block current;
        private ListIterator<Block> iterator;

        BlockIterator(List<Block> blocks) {
            this.iterator = blocks.listIterator();
        }

        boolean hasMoreBlocks() {
            while (this.current == null && this.iterator.hasNext()) {
                this.current = this.iterator.next();
                if (this.current.length != 0) continue;
                this.current = null;
            }
            return this.current != null;
        }

        Block nextBlock() {
            if (this.current == null && !this.hasMoreBlocks()) {
                return null;
            }
            Block ret = this.current;
            this.current = null;
            return ret;
        }
    }

    private static class Block {
        private byte[] bytes = new byte[4096];
        private int length;

        private Block() {
        }

        void reset() {
            this.length = 0;
        }

        int remain() {
            return this.bytes.length - this.length;
        }
    }

    public static final class DefaultPosIncrementer
    implements ReadableTToken.TokenPositionIncrementer {
        public int getPositionIncrement(ReadableTToken token) {
            int result = 0;
            TToken.Type tokenType = token.getType();
            result = TToken.Type.BOTH == tokenType || TToken.Type.ORIGINAL == tokenType || TToken.Type.NGRAM == tokenType ? this.getMinPositionIncrement() : (TToken.Type.SENTENCE == tokenType ? this.getSentencePositionIncrement() : Math.max(0, token.getPositionIncrement()));
            return result;
        }

        public int getMinPositionIncrement() {
            return 1;
        }

        public int getSentencePositionIncrement() {
            return 3;
        }
    }
}

